<?php
// db/tracking-codes-update.php
ob_start();
header('Content-Type: application/json');
require_once '../core/api.php';

try {
    $biz_id = 1;
    $head = $_POST['tracking_codes_head'] ?? '';
    $body = $_POST['tracking_codes_body'] ?? '';
    $user_id = 1; 

    $check = $pdo->prepare("SELECT id FROM tracking_codes WHERE business_info_id = ?");
    $check->execute([$biz_id]);

    if ($check->fetch()) {
        $stmt = $pdo->prepare("UPDATE tracking_codes SET tracking_codes_head=?, tracking_codes_body=? WHERE business_info_id=?");
        $stmt->execute([$head, $body, $biz_id]);
    } else {
        $stmt = $pdo->prepare("INSERT INTO tracking_codes (business_info_id, user_id, tracking_codes_head, tracking_codes_body) VALUES (?, ?, ?, ?)");
        $stmt->execute([$biz_id, $user_id, $head, $body]);
    }

    echo json_encode(['success' => true]);
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
ob_end_clean();
?>