<?php
ob_start();
header('Content-Type: application/json');
$response = ['success' => false, 'message' => 'ERROR DESCONOCIDO'];

// Definicin de variables de subida de archivos
$uploadDir = '../uploads/services/';
$currentImagePath = null;

try {
    require_once '../core/api.php';

    ini_set('display_errors', 0);
    ini_set('log_errors', 1);
    error_reporting(E_ALL);

    // --- RECEPCI07N DE DATOS ---
    $id = isset($_POST['id']) ? $_POST['id'] : null;
    $name = isset($_POST['name']) ? trim($_POST['name']) : null;
    $price = isset($_POST['price']) ? $_POST['price'] : null;
    $category_input = isset($_POST['category']) ? trim($_POST['category']) : null;
    $description = isset($_POST['description']) ? trim($_POST['description']) : null; 
    
    // NUEVOS CAMPOS/ACTUALES
    $features = isset($_POST['features']) ? trim($_POST['features']) : null;
    $youtube_link = isset($_POST['youtube_link']) ? trim($_POST['youtube_link']) : null;
    
    // RUTAS ACTUALES (Opcional, se puede recuperar de la DB si es ms seguro)
    $currentImagePath = isset($_POST['current_image_path']) ? trim($_POST['current_image_path']) : null;
    $currentGalleryImages = isset($_POST['current_gallery_images']) ? trim($_POST['current_gallery_images']) : null;

    // VALIDACI07N B09SICA
    if (!$id || !$name || !$price) {
        throw new Exception('DATOS INCOMPLETOS');
    }

    $id = filter_var($id, FILTER_VALIDATE_INT);
    $name = filter_var($name, FILTER_SANITIZE_FULL_SPECIAL_CHARS);
    $price = filter_var($price, FILTER_VALIDATE_FLOAT);

    if ($id === false || $price === false) {
        throw new Exception('ID O PRECIO INV09LIDO');
    }

    // Funcin de ayuda para validar URL de YouTube (la misma que en create)
    function validateYoutubeUrl($url) {
        if (empty($url)) return null;
        $pattern = '/^(?:https?:\/\/)?(?:www\.)?(?:youtube\.com\/(?:[^\/\n\s]+\/\S+\/|(?:v|e(?:mbed)?)\/|\S*?[?&]v=)|youtu\.be\/)([a-zA-Z0-9_-]{11})/';
        if (preg_match($pattern, $url, $matches)) {
            return $url; 
        }
        return null; 
    }
    $youtube_link_safe = validateYoutubeUrl($youtube_link);

    $imagePathToSave = $currentImagePath; 
    
    if (!empty($youtube_link_safe)) {
        $imagePathToSave = null;
    } elseif (isset($_FILES['image']) && $_FILES['image']['error'] === UPLOAD_ERR_OK) {
        $fileTmpPath = $_FILES['image']['tmp_name'];
        $fileName = $_FILES['image']['name'];
        $fileExtension = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));
        
        $newFileName = 'svc_' . uniqid() . '.' . $fileExtension;
        $destPath = $uploadDir . $newFileName;

        if (move_uploaded_file($fileTmpPath, $destPath)) {
            $imagePathToSave = $newFileName;
        } else {
            error_log("Fallo al mover la nueva imagen principal: " . $fileName);
        }
    } 

    $galleryImagesToSave = $currentGalleryImages; 
    if (isset($_FILES['gallery_images']) && is_array($_FILES['gallery_images']['tmp_name']) && !empty(array_filter($_FILES['gallery_images']['tmp_name']))) {
        
        $newGalleryPaths = [];
        $count = 0;

        foreach ($_FILES['gallery_images']['tmp_name'] as $index => $tmpName) {
             if ($count >= 4) break; 
            
            if ($_FILES['gallery_images']['error'][$index] === UPLOAD_ERR_OK) {
                $fileName = $_FILES['gallery_images']['name'][$index];
                $fileExtension = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));
                
                $newFileName = 'gal_' . uniqid() . '_' . $index . '.' . $fileExtension;
                $destPath = $uploadDir . $newFileName;
                
                if (move_uploaded_file($tmpName, $destPath)) {
                    $newGalleryPaths[] = $newFileName;
                    $count++;
                }
            }
        }
        $galleryImagesToSave = !empty($newGalleryPaths) ? implode(',', $newGalleryPaths) : null;
    }

    // --- 3. VALIDACI07N DE CATEGOR01A ---
    $category_safe = null;
    if ($category_input) {
        $stmtCat = $pdo->prepare("SELECT name FROM service_categories WHERE name = ? LIMIT 1");
        $stmtCat->execute([$category_input]);
        if ($row = $stmtCat->fetch(PDO::FETCH_ASSOC)) {
            $category_safe = $row['name'];
        }
    }

    // --- 4. ACTUALIZACI07N EN LA DB ---
    $sql = "UPDATE services 
            SET name = ?, price = ?, category = ?, description = ?, image_path = ?, features = ?, youtube_link = ?, gallery_images = ?
            WHERE id = ?";
            
    $stmt = $pdo->prepare($sql);
    
    if ($stmt->execute([$name, $price, $category_safe, $description, $imagePathToSave, $features, $youtube_link_safe, $galleryImagesToSave, $id])) {
        $response = ['success' => true, 'message' => 'SERVICIO ACTUALIZADO CORRECTAMENTE'];
    } else {
        throw new Exception('FALLO AL EJECUTAR ACTUALIZACI07N');
    }
} catch (PDOException $e) {
    error_log("PDO Error: " . $e->getMessage());
    $response['message'] = 'ERROR DE BASE DE DATOS';
} catch (Exception $e) {
    $response['message'] = $e->getMessage();
}

if (ob_get_level() > 0) ob_end_clean();
echo json_encode($response);
exit;
?>