<?php
ob_start();
header('Content-Type: application/json');
$response = ['success' => false, 'message' => 'ERROR DESCONOCIDO'];

$uploadDir = '../uploads/services/';
$imagePath = null;
$currentImagePath = isset($_POST['current_image_path']) ? trim($_POST['current_image_path']) : null; 

try {
    require_once '../core/api.php';

    ini_set('display_errors', 0);
    ini_set('log_errors', 1);
    error_reporting(E_ALL);

    // --- RECEPCI07N DE DATOS ---
    $name = isset($_POST['name']) ? trim($_POST['name']) : null;
    $price = isset($_POST['price']) ? $_POST['price'] : null;
    $category_input = isset($_POST['category']) ? trim($_POST['category']) : null;
    $description = isset($_POST['description']) ? trim($_POST['description']) : null; 
    $features = isset($_POST['features']) ? trim($_POST['features']) : null;
    
    // Capturar el link de YouTube
    $youtube_link = isset($_POST['youtube_link']) ? trim($_POST['youtube_link']) : null;

    // VALIDACI07N B09SICA
    if (!$name || !$price) {
        throw new Exception('DATOS B09SICOS INCOMPLETOS');
    }
    
    $name = filter_var($name, FILTER_SANITIZE_FULL_SPECIAL_CHARS);
    $price = filter_var($price, FILTER_VALIDATE_FLOAT);

    if ($price === false) {
        throw new Exception('PRECIO INV09LIDO');
    }
    
    // Funcin de ayuda para validar URL de YouTube
    function validateYoutubeUrl($url) {
        if (empty($url)) return null;
        $pattern = '/^(?:https?:\/\/)?(?:www\.)?(?:youtube\.com\/(?:[^\/\n\s]+\/\S+\/|(?:v|e(?:mbed)?)\/|\S*?[?&]v=)|youtu\.be\/)([a-zA-Z0-9_-]{11})/';
        if (preg_match($pattern, $url, $matches)) {
            return $url; 
        }
        return null; 
    }

    $youtube_link_safe = validateYoutubeUrl($youtube_link);

    // --- 1. PROCESAR SUBIDA DE IMAGEN PRINCIPAL (Solo si no hay link de YouTube) ---
    if (!empty($youtube_link_safe)) {
        $imagePath = null;
    } elseif (isset($_FILES['image']) && $_FILES['image']['error'] === UPLOAD_ERR_OK) {
        $fileTmpPath = $_FILES['image']['tmp_name'];
        $fileName = $_FILES['image']['name'];
        $fileExtension = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));
        
        $newFileName = 'svc_' . uniqid() . '.' . $fileExtension;
        $destPath = $uploadDir . $newFileName;

        if (move_uploaded_file($fileTmpPath, $destPath)) {
            $imagePath = $newFileName;
        } else {
            error_log("Fallo al mover la imagen principal: " . $fileName);
        }
    }
    
    // --- 2. PROCESAR SUBIDA DE IM09GENES DE GALER01A (Mximo 4) ---
    $galleryImagesPaths = [];
    if (isset($_FILES['gallery_images']) && is_array($_FILES['gallery_images']['tmp_name'])) {
        $count = 0;
        foreach ($_FILES['gallery_images']['tmp_name'] as $index => $tmpName) {
            if ($count >= 4) break; 
            
            if ($_FILES['gallery_images']['error'][$index] === UPLOAD_ERR_OK) {
                $fileName = $_FILES['gallery_images']['name'][$index];
                $fileExtension = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));
                
                $newFileName = 'gal_' . uniqid() . '_' . $index . '.' . $fileExtension;
                $destPath = $uploadDir . $newFileName;
                
                if (move_uploaded_file($tmpName, $destPath)) {
                    $galleryImagesPaths[] = $newFileName;
                    $count++;
                }
            }
        }
    }
    $galleryImagesString = !empty($galleryImagesPaths) ? implode(',', $galleryImagesPaths) : null;
    
    // --- 3. VALIDACI07N DE CATEGOR01A (EXISTENTE) ---
    $category_safe = null;
    if ($category_input) {
        $stmtCat = $pdo->prepare("SELECT name FROM service_categories WHERE name = ? LIMIT 1");
        $stmtCat->execute([$category_input]);
        if ($row = $stmtCat->fetch(PDO::FETCH_ASSOC)) {
            $category_safe = $row['name'];
        }
    }

    // --- 4. INSERCI07N EN LA DB ---
    $sql = "INSERT INTO services (name, price, category, description, image_path, features, youtube_link, gallery_images) 
            VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
    $stmt = $pdo->prepare($sql);
    
    if ($stmt->execute([$name, $price, $category_safe, $description, $imagePath, $features, $youtube_link_safe, $galleryImagesString])) {
        $response = ['success' => true, 'message' => 'SERVICIO CREADO CORRECTAMENTE'];
    } else {
        throw new Exception('FALLO AL EJECUTAR INSERCI07N DEL SERVICIO');
    }
} catch (PDOException $e) {
    error_log("PDO Error: " . $e->getMessage());
    $response['message'] = 'ERROR DE BASE DE DATOS';
} catch (Exception $e) {
    $response['message'] = $e->getMessage();
}

if (ob_get_level() > 0) ob_end_clean();
echo json_encode($response);
exit;
?>