<?php
// db/quote-action-handler.php
header('Content-Type: application/json');
require_once '../core/api.php'; 

// Leer JSON
$data = json_decode(file_get_contents('php://input'), true);
$token = $data['token'] ?? '';
$action = $data['action'] ?? ''; 
$feedback = $data['feedback'] ?? '';

if (!$token || !$action) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid Request']);
    exit;
}

try {
    // 1. Obtener ID de la cotización (tabla quotes)
    $stmt = $pdo->prepare("SELECT id, status FROM quotes WHERE external_id = ? LIMIT 1");
    $stmt->execute([$token]);
    $estimate = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$estimate) {
        echo json_encode(['status' => 'error', 'message' => 'Quote not found']);
        exit;
    }

    // 2. Lógica según acción
    if ($action === 'approve') {
        // Aprobar: Cambia estado (a 'converted' según el esquema) y guarda timestamp
        $sql = "UPDATE quotes SET 
                status = 'converted', 
                client_feedback = NULL,
                approved_at = NOW(),
                updated_at = NOW() 
                WHERE id = ?";
        $pdo->prepare($sql)->execute([$estimate['id']]);

    } elseif ($action === 'request_changes') {
        // Solicitar Cambios: Cambia estado a 'sent' (o un estado intermedio para revisión) y guarda el feedback
        $sql = "UPDATE quotes SET 
                status = 'sent', 
                client_feedback = ?,
                updated_at = NOW() 
                WHERE id = ?";
        $pdo->prepare($sql)->execute([$feedback, $estimate['id']]);
        
    }

    echo json_encode(['status' => 'success']);

} catch (Exception $e) {
    error_log("QUOTE ACTION ERROR: " . $e->getMessage());
    echo json_encode(['status' => 'error', 'message' => 'Server Error']);
}
?>