<?php
ob_start();
header('Content-Type: application/json');
$response = ['success' => false, 'data' => [], 'message' => 'ERROR DESCONOCIDO'];

try {
    require_once __DIR__ . '/../core/api.php';

    ini_set('display_errors', 0);
    ini_set('log_errors', 1);
    ini_set('error_log', __DIR__ . '/../logs/php_errors.log');
    error_reporting(E_ALL);

    $stmt = $pdo->prepare("SELECT logo_url FROM business_info WHERE id = ? LIMIT 1");
    $stmt->execute([1]);
    $data = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$data || empty($data['logo_url'])) {
        $data = ['logo_url' => 'brand/img/LogoCRM.webp'];
    }
    
    $response = ['success' => true, 'data' => $data];

} catch (PDOException $e) {
    error_log("Error PDO en logo-read.php: " . $e->getMessage());
    $response['message'] = 'ERROR DE BASE DE DATOS';
} catch (Exception $e) {
    error_log("Error general en logo-read.php: " . $e->getMessage());
    $response['message'] = 'ERROR INTERNO';
}

if (ob_get_level() > 0) {
    ob_end_clean();
}
echo json_encode($response);
exit;
?>