<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

try {
    include_once 'files/guardiankey.php';
} catch (Exception $e) {
    error_log("Error critico al cargar Guardian Key en thank-you.php: " . $e->getMessage());
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mensaje Enviado Exitosamente <?php echo htmlspecialchars($branding['full_title']); ?></title>
    <meta name="robots" content="noindex, nofollow">
    
    <link rel="icon" type="image/png" href="<?php echo htmlspecialchars($branding['favicon']); ?>">
    <link rel="apple-touch-icon" href="<?php echo htmlspecialchars($branding['favicon']); ?>">
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="<?php echo htmlspecialchars($google_font_url); ?>">

    <?php include 'files/gtm-head.php'; ?>
    
    <script src="https://unpkg.com/lucide@latest"></script>
    <link rel="stylesheet" href="style.css">
    
    <style>
        .content-background {
            background-image: url('img/BG-FlowCRM.webp');
            background-size: cover;
            background-position: center;
            position: relative;
        }
        .overlay {
            background: linear-gradient(135deg, rgba(7, 22, 45, 0.85) 0%, rgba(158, 20, 40, 0.65) 100%);
            display: flex;
            align-items: center;
            justify-content: center;
            width: 100%;
        }
        .content-card {
            animation: fadeInScaleUp 0.6s ease-out forwards;
        }
        @keyframes fadeInScaleUp {
            from { opacity: 0; transform: scale(0.95); }
            to { opacity: 1; transform: scale(1); }
        }
    </style>
</head>
<body class="flex">

    <?php include 'menu.php'; ?>

    <div class="flex-1 flex flex-col">
        <main class="flex-1 flex flex-col content-background">
            <div class="overlay p-4 flex-1">
                
                <div class="max-w-2xl w-full text-center content-card">
                    <div class="flex justify-center mb-6">
                        <i data-lucide="check-circle-2" class="h-28 w-28 text-green-400 drop-shadow-lg"></i>
                    </div>
                    <h1 class="text-6xl font-extrabold text-white leading-tight drop-shadow-md">
                        ¡Mensaje Enviado!
                    </h1>
                    <p class="mt-4 text-xl text-gray-200 max-w-lg mx-auto drop-shadow-md">
                        Hemos Recibido Tu Consulta Correctamente.<br />Nos Pondremos En Contacto Contigo A La Brevedad<br />
                    </p>
                    
                    <div class="mt-10 max-w-xs mx-auto">
                        <a href="dashboard.php" class="btn-primary w-full flex items-center justify-center p-4 rounded-lg uppercase font-bold text-lg shadow-lg">
                            <i data-lucide="layout-dashboard" class="w-6 h-6 mr-3"></i>
                            <span>Ir al Panel</span>
                        </a>
                    </div>
                </div>

            </div>
        </main>
    </div>

    <script>
        lucide.createIcons();
    </script>
    <script src="files/toast.js"></script>
</body>
</html>