<?php
// INICIO DEL BUFFER DE SALIDA
ob_start();
// El require_once de GuardianKey u otros pueden generar texto no JSON
if (file_exists('../files/guardiankey.php')) {
    require_once '../files/guardiankey.php'; 
}
ob_end_clean(); 
// Creamos un nuevo buffer para la ejecución segura del resto del script
ob_start();

ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/../logs/php_errors.log');
error_reporting(E_ALL);

header('Content-Type: application/json');
require_once 'db_connection.php';

$response = ['status' => 'error', 'message' => 'Solicitud no válida.'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        $response['message'] = 'Error en el formato de los datos enviados.';
        echo json_encode($response);
        exit;
    }

    $type = $input['type'] ?? 'unica';
    
    // Sanitizar y validar datos básicos
    $client_id = filter_var($input['client_id'] ?? null, FILTER_VALIDATE_INT);
    $service_id = filter_var($input['service_id'] ?? null, FILTER_VALIDATE_INT);
    $notes = filter_var($input['notes'] ?? 'Appointment requested by client from web portal.', FILTER_SANITIZE_FULL_SPECIAL_CHARS);

    // Validación CRÍTICA
    if (!$client_id || !$service_id) {
        $response['message'] = 'Es necesario proporcionar un ID de cliente y seleccionar un servicio.';
        echo json_encode($response);
        exit;
    }

    try {
        if ($type === 'unica') {
            $appointment_date = $input['appointment_date'] ?? null;
            $appointment_time = $input['appointment_time'] ?? null;

            if (empty($appointment_date) || empty($appointment_time)) {
                $response['message'] = 'La fecha y la hora son obligatorias.';
                echo json_encode($response);
                exit;
            }
            
            // --- VERIFICACIÓN DE CAPACIDAD EN EL SERVIDOR ---
            $stmt_config = $pdo->query("SELECT capacity FROM schedule_config WHERE id = 1");
            $config = $stmt_config->fetch(PDO::FETCH_ASSOC);
            $capacity = $config ? (int)$config['capacity'] : 1; // Default a 1 si no hay config

            $stmt_booked = $pdo->prepare("SELECT COUNT(*) FROM unique_appointments WHERE appointment_date = ? AND appointment_time = ? AND status != 'cancelled'");
            $stmt_booked->execute([$appointment_date, $appointment_time]);
            $booked_count = (int)$stmt_booked->fetchColumn();

            if ($booked_count >= $capacity) {
                $response['status'] = 'error';
                $response['message'] = 'Lo sentimos, este horario se acaba de llenar. Por favor, selecciona otro.';
                echo json_encode($response);
                exit;
            }
            // --- FIN DE LA VERIFICACIÓN ---

            $status = 'pending';
            $stmt = $pdo->prepare(
                "INSERT INTO unique_appointments (client_id, service_id, appointment_date, appointment_time, status, notes) 
                 VALUES (?, ?, ?, ?, ?, ?)"
            );
            $stmt->execute([$client_id, $service_id, $appointment_date, $appointment_time, $status, $notes]);
            
            if ($stmt->rowCount() > 0) {
                $response = ['status' => 'success', 'message' => 'Cita agendada con éxito.'];
            } else {
                throw new Exception('No se pudo insertar la cita en la base de datos.');
            }
        }
    } catch (PDOException $e) {
        error_log("Error PDO en agenda-create.php: " . $e->getMessage());
        $response['message'] = 'Error de base de datos. Por favor, contacta a soporte.';
    } catch (Exception $e) {
        error_log("Error en agenda-create.php: " . $e->getMessage());
        $response['message'] = 'Error del servidor al agendar la cita: ' . $e->getMessage();
    }
}

ob_end_clean();
echo json_encode($response);
exit;
?>