<?php
// payment-data.php - Captura los datos de éxito del pago de Dodo y REDIRIGE.

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

$next_renewal_date = null;
$amount = 0;
$currency = 'USD';
$transaction_id = 'N/A';
$customer_email = null;

// --- 1. CAPTURA DE DATOS DESDE EL REDIRECT ---
// Usamos $_REQUEST para capturar tanto GET como POST.

$customer_email = $_REQUEST['email'] ?? $_SESSION['user_email'] ?? null;

// Capturamos el ID. Usamos 'transaction_id' o 'id' o 'trx_id'
$transaction_id = $_REQUEST['transaction_id'] ?? $_REQUEST['id'] ?? $_REQUEST['trx_id'] ?? 'N/A';

// Capturamos el MONTO. Intentaremos con 'amount', 'total', o 'price'. Esto fue lo que falló.
// Lo guardamos como INT para evitar problemas de formato.
$amount = intval($_REQUEST['amount'] ?? $_REQUEST['total'] ?? $_REQUEST['price'] ?? 0); 

$currency = $_REQUEST['currency'] ?? 'USD';

// --- 2. BÚSQUEDA DE DATOS EN LA BASE DE DATOS Y CÁLCULO DE FECHA ---
if ($customer_email) {
    try {
        // La conexión a DB debe ser relativa al archivo
        require_once __DIR__ . '/db/db_connection.php'; 
        if (isset($pdo)) { $db = $pdo; }
        
        if (isset($db)) {
            // Buscamos la próxima fecha de factura (next_invoice_date) y la fecha de la última renovación (plan_renewal_date)
            $sql = "SELECT next_invoice_date, plan_renewal_date FROM users WHERE email = ?";
            $stmt = $db->prepare($sql);
            $stmt->execute([$customer_email]);
            $user_data = $stmt->fetch(PDO::FETCH_ASSOC);

            if ($user_data) {
                // 1. Intentamos usar la fecha ACTUALIZADA por el Webhook (si funcionó).
                $next_renewal_date = $user_data['next_invoice_date'];

                // 2. Si el Webhook falló ($next_invoice_date es nulo/viejo), CALCULAMOS la próxima fecha.
                // Usamos la fecha de la última renovación exitosa (que sí debería estar registrada por el primer pago).
                if (!$next_renewal_date || $next_renewal_date === '0000-00-00') {
                     $base_date_string = $user_data['plan_renewal_date'] ?? date('Y-m-d'); // Usar fecha de DB o fecha de hoy
                     $base_date = date_create($base_date_string);

                     // Calcular la próxima fecha de renovación sumando 1 mes a la fecha base
                     date_add($base_date, date_interval_create_from_date_string("1 month"));
                     $next_renewal_date = date_format($base_date, 'Y-m-d');
                }
            }
        }
    } catch (Exception $e) {
        error_log("Error al buscar datos de renovación en la DB: " . $e->getMessage());
    }
}


// --- 3. REDIRECCIÓN FINAL ---
if ($amount > 0 && $next_renewal_date) { 
    $params = http_build_query([
        'next_renewal' => $next_renewal_date,
        'amount' => $amount, 
        'currency' => $currency,
        'trx_id' => $transaction_id
    ]);
    header("Location: payment-confirmed.php?" . $params);
    exit();
} else {
    // Manejo de fallas: Monto o fecha faltante.
    $error_msg = "Pago confirmado, pero los detalles (Monto/ID/Fecha) no se recibieron. Por favor, contacta a soporte.";
    
    // Si el monto es 0 o menor, es el error que estamos viendo.
    if ($amount <= 0) {
        $error_msg = "Error al capturar el MONTO de la transacción. El pago fue exitoso, contacte a soporte con su ID de transacción: " . $transaction_id;
    }
    
    header("Location: dashboard.php?notification_type=error&notification_message=" . urlencode($error_msg));
    exit();
}
?>