<?php
// CARGA MAESTRA DE CONFIGURACIÓN Y BRANDING
require_once(__DIR__ . '/core/init.php');
try {
    $business_name = $client_info['business_name'] ?? 'Tu Negocio Exitoso';
    $logo_url = $client_info['logo_url'] ?? 'img/favicon.png';

} catch (Exception $e) {
    error_log("Error inicial en payment-confirmed.php: " . $e->getMessage());
    $business_name = 'Tu Negocio Exitoso';
    $logo_url = 'img/favicon.png';
}

// --- 2. Carga de Datos Dinámicos (Transacción) ---
$next_renewal_date = $_GET['next_renewal'] ?? 'N/A';
$amount_paid = number_format(($_GET['amount'] ?? 0) / 100, 2);
$currency_code = $_GET['currency'] ?? 'USD';
$transaction_id = $_GET['trx_id'] ?? 'N/A';

// Formatear la fecha
if ($next_renewal_date !== 'N/A') {
    $date_obj = date_create($next_renewal_date);
    $next_renewal_date = date_format($date_obj, 'd/m/Y');
} else {
    $next_renewal_date = 'Pendiente';
}

ob_end_clean();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <title>Membresía Renovada Exitosamente <?php echo htmlspecialchars($branding['full_title']); ?></title>
    <meta name="robots" content="noindex, nofollow">
    
    <link rel="icon" type="image/png" href="<?php echo htmlspecialchars($branding['favicon']); ?>">
    <link rel="apple-touch-icon" href="<?php echo htmlspecialchars($branding['favicon']); ?>">
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="<?php echo htmlspecialchars($google_font_url); ?>">

    <?php include 'files/gtm-head.php'; ?>
    
    <script src="https://unpkg.com/lucide@latest"></script>

    <link rel="stylesheet" href="style.css">
    
    <style>
        .content-background {
            background-image: url('img/BG-FlowCRM.webp'); 
            background-size: cover;
            background-position: center;
            position: relative;
        }
        .overlay {
            background: linear-gradient(135deg, rgba(31, 63, 102, 0.95) 0%, rgba(158, 20, 40, 0.85) 100%);
            display: flex;
            align-items: center;
            justify-content: center;
            width: 100%;
            height: 100%;
        }
        .content-container {
            max-width: 900px;
            width: 100%;
            display: grid;
            grid-template-columns: 1fr;
            gap: 2rem;
            animation: fadeInScaleUp 0.6s ease-out forwards;
        }
        @media (min-width: 768px) {
            .content-container {
                grid-template-columns: 1.5fr 1fr; 
            }
        }

        .content-card-base {
            padding: 2.5rem;
            border-radius: 1rem;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.3);
        }
        .content-card-left {
            background-color: white; 
            text-align: center;
        }
        .content-card-right {
            background-color: var(--color-primary); 
            color: white;
            border: 1px solid rgba(255, 255, 255, 0.2);
            display: flex; 
            flex-direction: column;
            justify-content: space-between;
        }

        @keyframes fadeInScaleUp {
            from { opacity: 0; transform: translateY(30px); }
            to { opacity: 1; transform: translateY(0); }
        }

    </style>
</head>
<body class="content-background">

    <div class="overlay p-4 flex-col">
        
        <div class="content-container">
            
            <div class="content-card-base content-card-left">
                
                <div class="mx-auto mb-6 flex items-center justify-center w-20 h-20 bg-green-500 rounded-full shadow-xl">
                    <i data-lucide="check" class="w-10 h-10 text-white"></i>
                </div>
                
                <h1 class="text-4xl font-black uppercase text-gray-900 mb-2 leading-tight">
                    ¡Membresía Renovada con Éxito!
                </h1>
                <p class="text-lg text-gray-600 mb-8 font-medium">
                    Has asegurado la <b>continuidad de tu servicio mensual</b>. Es momento de enfocarse en el <b>crecimiento</b> de tu negocio.
                </p>
                
                <div class="mb-6 p-4 bg-gray-100 rounded-lg border border-gray-200">
                    <h4 class="text-2xl font-black uppercase text-gray-800 flex items-center justify-center gap-2 mb-2">
                        <i data-lucide="zap" class="w-5 h-5 text-indigo-500"></i> Herramientas listas para ti
                    </h4>
                    <p class="text-sm text-gray-600">
                        Tu inversión asegura que todas las funciones de <b>automatización y gestión de clientes</b> se mantengan activas durante el próximo ciclo.
                    </p>
                </div>


                <div class="mt-8 space-y-4">
                    <a href="dashboard.php" class="bg-[var(--color-highlight)] w-full flex items-center justify-center p-4 rounded-lg uppercase font-extrabold text-lg shadow-lg">
                        <i data-lucide="layout-dashboard" class="w-6 h-6 mr-3"></i>
                        Ir a mi Panel de Control
                    </a>
                    <a href="account.php" class="bg-gray-200 text-gray-800 hover:bg-gray-300 w-full flex items-center justify-center p-3 rounded-lg uppercase font-bold text-base transition-all duration-300">
                        <i data-lucide="file-text" class="w-5 h-5 mr-2"></i>
                        Gestionar Membresía
                    </a>
                </div>
            </div>
            
            <div class="content-card-base content-card-right">
                
                <div class="mb-8 text-center border-b border-gray-600 pb-4">
                    <img src="<?php echo htmlspecialchars($logo_url); ?>" 
                        alt="<?php echo htmlspecialchars($business_name); ?> Logo" 
                        class="w-24 h-24 object-contain mx-auto mb-3 rounded-full border-4 border-white p-1 shadow-xl bg-white"
                        onerror="this.onerror=null;this.src='https://placehold.co/96x96/ffffff/333333?text=Logo';"
                    >
                    <h2 class="text-3xl font-extrabold leading-snug text-white">
                        <?php echo htmlspecialchars($business_name); ?>
                    </h2>
                    <p class="text-xs font-medium text-gray-300 uppercase">Resumen de Inversión</p>
                </div>

                <div>
                    <h3 class="text-xl font-bold mb-4 uppercase flex items-center gap-2 text-white">
                        <i data-lucide="receipt" class="w-5 h-5 text-[var(--color-highlight)]"></i>
                        Detalles de tu Pago
                    </h3>
                    
                    <div class="space-y-4 text-base">
                        <div class="flex justify-between border-b border-gray-600 pb-2">
                            <span class="font-semibold text-gray-300">Monto Invertido:</span>
                            <span class="font-bold text-green-400"><?php echo htmlspecialchars($currency_code . ' ' . $amount_paid); ?></span>
                        </div>
                        <div class="flex justify-between border-b border-gray-600 pb-2">
                            <span class="font-semibold text-gray-300">Próximo Pago:</span>
                            <span class="font-extrabold text-[var(--color-highlight)]"><?php echo htmlspecialchars($next_renewal_date); ?></span>
                        </div>
                        <div class="flex justify-between">
                            <span class="font-semibold text-gray-300">Comprobante ID:</span>
                            <span class="font-mono text-sm text-gray-200"><?php echo htmlspecialchars($transaction_id); ?></span>
                        </div>
                    </div>
                </div>

                <div class="mt-8">
                    </div>

            </div>

        </div>

    </div>

    <script>
        lucide.createIcons();
    </script>
    <script src="files/toast.js"></script>
</body>
</html>