<?php

$other_videos = [
    // --- SITEFLOW CMS (CONSTRUCTOR WEB) ---
    'cms-dashboard' => [
        'id'          => 'cms-dashboard',
        'title'       => 'PANEL SITEFLOW CMS',
        'description' => 'Gestiona la estructura, diseño y contenido de tu sitio web desde un solo lugar.',
        'video_url'   => 'https://crm.tunegociolocal.com/crm-media/videos/CMSDashboard.mp4',
        'poster_url'  => 'https://crm.tunegociolocal.com/crm-media/images/CMSDashboard.webp',
    ],
    'cms-business-info' => [
        'id'          => 'cms-business-info',
        'title'       => 'INFORMACIÓN DEL SITIO',
        'description' => 'Configura los datos de contacto, horarios, redes sociales y ubicación de tu web.',
        'video_url'   => 'https://crm.tunegociolocal.com/crm-media/videos/CMSBusinessInfo.mp4',
        'poster_url'  => 'https://crm.tunegociolocal.com/crm-media/images/CMSBusinessInfo.webp',
    ],
    'cms-account' => [
        'id'          => 'cms-account',
        'title'       => 'CONFIGURACIÓN CMS',
        'description' => 'Ajustes generales de tu cuenta de administrador web y preferencias.',
        'video_url'   => 'https://crm.tunegociolocal.com/crm-media/videos/CMSAccount.mp4',
        'poster_url'  => 'https://crm.tunegociolocal.com/crm-media/images/CMSAccount.webp',
    ],
    // Nota: Puedes agregar videos específicos por sección (Hero, Servicios, etc.) aquí si los necesitas.

    // --- IA STOCK (RECURSOS CREATIVOS) ---
    'stock-dashboard' => [
        'id'          => 'stock-dashboard',
        'title'       => 'DASHBOARD RECURSOS',
        'description' => 'Explora la biblioteca completa de recursos creativos para tus campañas.',
        'video_url'   => 'https://crm.tunegociolocal.com/crm-media/videos/StockDashboard.mp4',
        'poster_url'  => 'https://crm.tunegociolocal.com/crm-media/images/StockDashboard.webp',
    ],
    'stock-images' => [
        'id'          => 'stock-images',
        'title'       => 'BANCO DE IMÁGENES',
        'description' => 'Descarga fotografías de alta resolución libres de derechos para tu marketing.',
        'video_url'   => 'https://crm.tunegociolocal.com/crm-media/videos/StockImages.mp4',
        'poster_url'  => 'https://crm.tunegociolocal.com/crm-media/images/StockImages.webp',
    ],
    'stock-videos' => [
        'id'          => 'stock-videos',
        'title'       => 'CLIPS DE VIDEO',
        'description' => 'Videos de stock profesionales para crear contenido audiovisual impactante.',
        'video_url'   => 'https://crm.tunegociolocal.com/crm-media/videos/StockVideos.mp4',
        'poster_url'  => 'https://crm.tunegociolocal.com/crm-media/images/StockVideos.webp',
    ],
    'stock-audios' => [
        'id'          => 'stock-audios',
        'title'       => 'EFECTOS Y AUDIOS',
        'description' => 'Música y efectos de sonido para enriquecer tus producciones.',
        'video_url'   => 'https://crm.tunegociolocal.com/crm-media/videos/StockAudios.mp4',
        'poster_url'  => 'https://crm.tunegociolocal.com/crm-media/images/StockAudios.webp',
    ],
    'stock-templates' => [
        'id'          => 'stock-templates',
        'title'       => 'PLANTILLAS EDITABLES',
        'description' => 'Plantillas listas para usar en tus diseños y documentos.',
        'video_url'   => 'https://crm.tunegociolocal.com/crm-media/videos/StockTemplates.mp4',
        'poster_url'  => 'https://crm.tunegociolocal.com/crm-media/images/StockTemplates.webp',
    ],
    'stock-documents' => [
        'id'          => 'stock-documents',
        'title'       => 'DOCUMENTOS Y GUÍAS',
        'description' => 'Recursos documentales, checklists y guías estratégicas.',
        'video_url'   => 'https://crm.tunegociolocal.com/crm-media/videos/StockDocuments.mp4',
        'poster_url'  => 'https://crm.tunegociolocal.com/crm-media/images/StockDocuments.webp',
    ],

    // --- SOCIOS DE CRECIMIENTO ---
    'socios-dashboard' => [
        'id'          => 'socios-dashboard',
        'title'       => 'COMUNIDAD DE SOCIOS',
        'description' => 'Conecta con otros emprendedores y accede a recursos exclusivos de la comunidad.',
        'video_url'   => 'https://crm.tunegociolocal.com/crm-media/videos/SociosDashboard.mp4',
        'poster_url'  => 'https://crm.tunegociolocal.com/crm-media/images/SociosDashboard.webp',
    ],
    'socios-mentalidad' => [
        'id'          => 'socios-mentalidad',
        'title'       => 'MENTALIDAD Y LIDERAZGO',
        'description' => 'Contenido enfocado en el desarrollo personal y mindset empresarial.',
        'video_url'   => 'https://crm.tunegociolocal.com/crm-media/videos/SociosMentalidad.mp4',
        'poster_url'  => 'https://crm.tunegociolocal.com/crm-media/images/SociosMentalidad.webp',
    ],
];

function get_other_video_by_id(string $video_id): ?array {
    global $other_videos;
    return $other_videos[$video_id] ?? null;
}