<?php
// CARGA MAESTRA DE CONFIGURACIÓN Y BRANDING
require_once(__DIR__ . '/core/init.php');
$logo_url_for_spinner = htmlspecialchars($branding['favicon'] ?? ''); 
$logo_url_main = htmlspecialchars($logo_url ?? '');
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <title>Perfil Completo De Empleado <?php echo htmlspecialchars($branding['full_title']); ?></title>
    <meta name="robots" content="noindex, nofollow">
    
    <link rel="icon" type="image/png" href="<?php echo htmlspecialchars($branding['favicon']); ?>">
    <link rel="apple-touch-icon" href="<?php echo htmlspecialchars($branding['favicon']); ?>">
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="<?php echo htmlspecialchars($google_font_url); ?>"> 

    <?php include 'files/gtm-head.php'; ?>
    
    <script src="https://unpkg.com/lucide@latest"></script>
    <link rel="stylesheet" href="style.css">
    <script src="files/header-manager.js"></script>
 
    <style>
        .fbi-overlay {
            position: fixed; inset: 0; 
            background: var(--color-primary); 
            z-index: 9999;
            display: flex; flex-direction: column; align-items: center; justify-content: center;
        }
        .loading-container {
            position: relative;
            width: 200px; 
            height: 200px; 
            margin-bottom: 20px;
        }
        .radar {
            width: 100%; height: 100%; 
            border: 2px solid rgba(158,20,40,0.2);
            border-top: 4px solid var(--color-secondary); 
            border-radius: 50%;
            animation: spin 1s linear infinite;
            box-shadow: 0 0 15px rgba(158,20,40,0.5);
            position: absolute;
            top: 0; left: 0;
        }
        .logo-center {
            position: absolute;
            top: 50%; left: 50%;
            transform: translate(-50%, -50%);
            width: 70%; 
            height: 70%; 
            border-radius: 50%;
            background-color: white; 
            padding: 5px;
            object-fit: contain;
        }
        @keyframes spin { to { transform: rotate(360deg); } }
        .blink { animation: blinker 1s linear infinite; }
        @keyframes blinker { 50% { opacity: 0; } }
        
        #results-dropdown {
            position: absolute; width: 100%; bg: white; z-index: 50;
            max-height: 300px; overflow-y: auto; border: 1px solid #e2e8f0;
            border-radius: 0.5rem; box-shadow: 0 10px 15px -3px rgba(0,0,0,0.1);
        }
        .result-item:hover { background-color: #f1f5f9; cursor: pointer; }

        .chart-bar-container {
            display: flex;
            align-items: flex-end;
            gap: 4px;
            height: 150px;
            padding-top: 10px;
            margin-top: 10px;
        }
        .chart-bar {
            width: 8.33%; 
            background-color: var(--color-secondary);
            transition: height 0.5s ease-out;
            border-top-left-radius: 2px;
            border-top-right-radius: 2px;
            position: relative;
            cursor: pointer;
        }
        .chart-bar-label {
            position: absolute;
            bottom: -20px;
            left: 50%;
            transform: translateX(-50%);
            font-size: 10px;
            font-weight: bold;
            color: #64748b;
        }
        .chart-bar-tooltip {
            position: absolute;
            top: -30px;
            left: 50%;
            transform: translateX(-50%);
            background-color: #1f2937;
            color: white;
            padding: 4px 8px;
            border-radius: 4px;
            font-size: 10px;
            font-weight: bold;
            white-space: nowrap;
            opacity: 0;
            transition: opacity 0.2s;
            pointer-events: none;
        }
        .chart-bar:hover .chart-bar-tooltip {
            opacity: 1;
        }
    </style>
    
    </head>
<body data-page-title="Perfil Completo Y Detallado De Empleados"
data-page-subtitle="Gestión De Miembros Del Equipo Corporativo" 
data-page-icon="users">
    
    <div id="toast-container" class="toast-container"></div>
    
<?php include 'files/gtm-body.php'; ?>  

<div class="relative min-h-screen md:flex">
    <div id="sidebar-overlay" class="fixed inset-0 bg-black bg-opacity-50 z-30 hidden md:hidden"></div>
    <div id="task-panel-overlay" class="fixed inset-0 bg-black/60 z-40 hidden transition-opacity duration-300"></div>  
    
    <?php include 'menu.php'; ?>
    
    <main class="flex-1 overflow-y-auto">
        <header class="bg-white shadow-md p-4 flex justify-between items-center sticky top-0 z-20">
            <button id="mobile-menu-button" class="md:hidden text-gray-600 hover:text-gray-800">
                <i data-lucide="menu" class="w-6 h-6"></i>
            </button>
            <div class="page-header-container">
                <h2 id="page-title"></h2>
                <p id="page-subtitle"></p>
            </div>
        </header>

        <div id="fbi-screen" class="fbi-overlay hidden">
        <div class="loading-container">
            <div class="radar"></div>
            <img src="<?php echo htmlspecialchars($biz['logo_url']); ?>" alt="Logo <?php echo htmlspecialchars($biz['company_name'] ?? ''); ?>" class="logo-center">
        </div>
        <div id="fbi-text" class="text-2xl font-bold uppercase tracking-widest mb-2 text-white">INICIANDO...</div>
        <div id="fbi-subtext" class="text-md uppercase font-semibold text-gray-400 ">Esperando conexión segura</div>
    </div>

    <div class="flex min-h-screen">

        <main class="flex-1 p-6 md:p-10">
            
            <div class="flex flex-col items-center text-center mb-8">
                <?php if (!empty($biz['logo_url'])): ?>
                    <div class="max-w-60 mb-4 flex items-center justify-center">
                        <img src="<?php echo htmlspecialchars($biz['logo_url']); ?>" alt="Logo <?php echo htmlspecialchars($biz['company_name'] ?? ''); ?>" class="max-w-full max-h-full object-contain">
                    </div>
                <?php endif; ?>

                <h1 class="text-4xl font-black uppercase text-[var(--color-primary)] mb-2">Busqueda Avanzada</h1>
            </div>

            <div class="max-w-3xl mx-auto mb-10 relative">
                <div class="relative max-w-xl mx-auto">
    <div class="flex items-center w-full shadow-lg rounded-2xl overflow-hidden border-2 border-gray-200 focus-within:border-[var(--color-secondary)] transition-all duration-300">
    
    <div class="relative flex-grow">
        <input 
            type="text" 
            id="search-input" 
            class="w-full h-14 p-4 pl-14 pr-4 bg-white
                   focus:outline-none 
                   text-base font-semibold text-gray-700 placeholder-gray-500
                   border-none ring-0
                   "
            placeholder="Buscar Empleado..." 
            autocomplete="off"
        >
        
        <i data-lucide="search" class="absolute left-4 top-1/2 transform -translate-y-1/2 w-6 h-6 text-gray-400 pointer-events-none"></i>
        
        <div id="input-loading" class="absolute right-4 top-1/2 transform -translate-y-1/2 hidden">
            <i data-lucide="loader-2" class="w-6 h-6 animate-spin text-indigo-500"></i>
        </div>

        <button id="clear-search" class="absolute right-4 top-1/2 transform -translate-y-1/2 hidden
                                         text-gray-400 hover:text-[var(--color-secondary)] transition-colors duration-200
                                         focus:outline-none" 
                title="Limpiar búsqueda">
            <i data-lucide="x-circle" class="w-6 h-6"></i>
        </button>
    </div>
    
    <button 
        id="trigger-search-button" 
        class="flex items-center justify-center h-14 px-6 bg-[var(--color-secondary)] uppercase text-white
               font-bold hover:bg-opacity-90 transition-all duration-300 whitespace-nowrap
               focus:outline-none"
        title="Buscar Cliente">
        <i data-lucide="user-search" class="w-5 h-5 mr-2"></i> Buscar Staff
    </button>
</div>
</div>

                <div id="results-dropdown" class="bg-white hidden mt-1"></div>
            </div>

            <div id="profile-view" class="hidden animate-fade-in">
                
                <div class="bg-white rounded-2xl shadow-xl overflow-hidden mb-6 border-t-4 border-[var(--color-secondary)]">
                    <div class="p-8 flex flex-col md:flex-row items-center gap-6">
                        <div class="w-24 h-24 bg-[var(--color-secondary)] rounded-full flex items-center justify-center text-3xl font-black text-white border-4 border-white shadow overflow-hidden">
                            <img id="p-photo-img" src="" class="w-full h-full object-cover hidden">
                            <span id="p-initials">--</span>
                        </div>
                        <div class="text-center md:text-left flex-1">
                            <h2 id="p-name" class="text-4xl font-black text-gray-800 uppercase leading-none mb-1">...</h2>
                            <p id="p-company" class="text-xl text-[var(--color-secondary)] font-bold mb-2">...</p>
                            <span id="p-type" class="px-3 py-1 rounded-full text-xs font-bold uppercase bg-gray-200 text-gray-600">STAFF</span>
                        </div>
                        <div id="p-loyalty-metric" class="text-right p-4 bg-gray-50 rounded-lg shadow-inner border border-gray-200">
                            <p class="text-xs uppercase font-black text-gray-500 mb-1">Rating Global</p>
                            <p class="text-xl font-black uppercase text-[var(--color-secondary)] leading-none" id="p-rating">--</p>
                        </div>
                    </div>
                </div>

                <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                    <div class="space-y-6">
                        <div class="bg-white p-6 rounded-xl shadow-md border-t-4 border-[var(--color-highlight)]">
                            <h3 class="font-black text-2xl text-[var(--color-primary)] uppercase">Datos de Contacto</h3>
                            <p><span id="p-code-creation" class="text-md uppercase font-bold text-[var(--color-secondary)]"></span></p>
                            <ul class="space-y-4 text-md font-medium text-gray-600">
                                <li class="flex gap-3"><i data-lucide="mail" class="text-[var(--color-secondary)] w-5"></i> <span id="p-email">--</span></li>
                                <li class="flex gap-3"><i data-lucide="phone" class="text-[var(--color-secondary)] w-5"></i> <span id="p-phone-main">--</span></li>
                                <li class="flex gap-3"><i data-lucide="calendar" class="text-[var(--color-secondary)] w-5"></i> Días: <span id="p-mobile">--</span></li>
                                <li class="flex gap-3"><i data-lucide="clock" class="text-[var(--color-secondary)] w-5"></i> <span id="p-schedule">--</span></li>
                                <li class="flex gap-3"><i data-lucide="info" class="text-[var(--color-secondary)] w-5"></i> Estado: <span id="p-address">--</span></li>
                                <li class="flex gap-3"><i data-lucide="key" class="text-[var(--color-secondary)] w-5"></i> Clave Acceso: <span id="p-access-code" class="font-bold text-[var(--color-secondary)]">--</span></li>
                            </ul>
                        </div>
                        
                        <div id="staff-section" class="bg-white p-6 rounded-xl shadow-md border-t-4 border-[var(--color-highlight)]">
                            <h3 class="font-black text-2xl text-[var(--color-primary)] uppercase mb-4 border-b pb-2">Información Interna</h3>
                            <div class="flex items-center gap-3">
                                <div>
                                    <p class="text-md font-bold text-gray-700">Código Empleado: <span id="p-emp-code" class="text-[var(--color-secondary)]">--</span></p>
                                    <p class="text-md font-bold text-gray-700 mt-2">Empleado del Mes: <span id="p-awards" class="text-[var(--color-success)]">0</span> veces</p>
                                </div>
                            </div>
                        </div>

                        <div id="route-section" class="bg-white p-6 rounded-xl shadow-md border-t-4 border-[var(--color-highlight)]">
                            <h3 class="font-black text-2xl text-[var(--color-primary)] uppercase mb-4 border-b pb-2 flex items-center gap-2"><i data-lucide="map" class="w-5 h-5 text-[var(--color-secondary)]"></i> Ruta Asignada</h3>
                            <div id="list-route"><div class="text-gray-400 italic text-md">Sin ruta asignada</div></div>
                        </div>

                        <div id="services-section" class="bg-white p-6 rounded-xl shadow-md border-t-4 border-[var(--color-highlight)]">
                            <h3 class="font-black text-2xl text-[var(--color-primary)] uppercase mb-4 border-b pb-2 flex items-center gap-2"><i data-lucide="dollar-sign" class="w-5 h-5 text-[var(--color-secondary)]"></i> Salario Actual</h3>
                            <div id="p-salary-display" class="text-2xl font-black text-gray-700">--</div>
                        </div>
                    </div>

                    <div class="lg:col-span-2 space-y-6">
                        <div id="financial-summary-section" class="bg-white p-6 rounded-2xl shadow-xl overflow-hidden mb-6 border-t-4 border-[var(--color-highlight)]">
                            <h3 id="financial-summary-title" class="font-black text-2xl text-[var(--color-primary)] uppercase mb-4 flex items-center gap-2">
                                <i data-lucide="wallet" class="w-6 h-6 text-[var(--color-secondary)]"></i> HONORARIOS Y HORAS
                            </h3>
                            <div class="grid grid-cols-3 gap-4 text-center">
                                <div><p class="text-3xl font-black text-[var(--color-success)]">$<span id="p-total-spent">0.00</span></p><p class="text-md text-gray-500 font-bold">TOTAL GANADO</p></div>
                                <div><p class="text-3xl font-black text-[var(--color-secondary)]"><span id="p-total-due">0.00</span></p><p class="text-md text-gray-500 font-bold">HORAS TRABAJADAS</p></div>
                                <div><p class="text-3xl font-black text-[var(--color-highlight)]">$<span id="p-total-estimated">0.00</span></p><p class="text-md text-gray-500 font-bold">TARIFA HORA</p></div>
                            </div>
                        </div>

                        <div class="bg-white p-6 rounded-xl shadow-md border-t-4 border-[var(--color-highlight)]">
                            <h3 class="font-black text-2xl text-[var(--color-primary)] uppercase mb-4 flex items-center gap-2"><i data-lucide="calendar" class="w-6 h-6 text-[var(--color-secondary)]"></i> CITAS ASIGNADAS</h3>
                            <div id="list-appointments" class="space-y-2 mt-4"></div>
                        </div>

                        <div class="bg-white p-6 rounded-xl shadow-md border-t-4 border-[var(--color-highlight)]">
                            <h3 class="font-black text-2xl text-[var(--color-primary)] uppercase mb-4 flex items-center gap-2"><i data-lucide="users" class="w-6 h-6 text-[var(--color-secondary)]"></i> CLIENTES ASIGNADOS</h3>
                            <div id="list-clients" class="space-y-2 mt-4"></div>
                        </div>
                        
                        <div class="bg-white p-6 rounded-xl shadow-md border-t-4 border-[var(--color-highlight)]">
                            <h3 class="font-black text-2xl text-[var(--color-primary)] uppercase mb-4 flex gap-2"><i data-lucide="alert-triangle" class="w-6 h-6 text-[var(--color-secondary)]"></i> QUEJAS DE CLIENTES</h3>
                            <div id="list-complaints" class="space-y-2"></div>
                        </div>
                        
                    </div>
                </div>
                
                <div class="space-y-6 mt-6">
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                        <div id="notes-section" class="bg-white p-6 rounded-xl shadow-md border-t-4 border-[var(--color-highlight)]">
                            <h3 class="font-black text-2xl text-[var(--color-primary)] uppercase mb-4 flex gap-2"><i data-lucide="video" class="w-6 h-6 text-[var(--color-secondary)]"></i> VIDEOS PRIVADOS</h3>
                            <div id="list-videos" class="space-y-3"></div>
                        </div>
                        <div id="projects-section" class="bg-white p-6 rounded-xl shadow-md border-t-4 border-[var(--color-highlight)]">
                            <h3 class="font-black text-2xl text-[var(--color-primary)] uppercase mb-4 flex gap-2"><i data-lucide="file-text" class="w-6 h-6 text-[var(--color-secondary)]"></i> DOCUMENTOS</h3>
                            <div id="list-documents" class="space-y-2"></div>
                        </div>
                    
                    </div>
                    
                    <div class="bg-white p-6 rounded-xl shadow-md border-t-4 border-[var(--color-highlight)]">
                        <h3 class="font-black text-2xl text-[var(--color-primary)] uppercase mb-4 flex items-center gap-2">
                            <i data-lucide="star" class="w-6 h-6 text-[var(--color-secondary)]"></i> Reseñas De Satisfacción
                        </h3>
                        <div id="list-reviews" class="space-y-4"></div>
                    </div>
                </div>
            </div>  
            
    <?php @include 'brand/powered.php'; ?>
    
        </main>
    </div>

<script>
    if(typeof lucide !== 'undefined') lucide.createIcons();
    
    const searchInput = document.getElementById('search-input');
    const dropdown = document.getElementById('results-dropdown');
    const inputLoading = document.getElementById('input-loading');
    const fbiScreen = document.getElementById('fbi-screen');
    const profileView = document.getElementById('profile-view');
    let debounceTimer;
    
    const formatNumberWithCommas = (number) => {
        if (typeof number !== 'number') return number;
        return number.toFixed(2).replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    };

    const formatDateUserFriendly = (dateString) => {
        if (!dateString) return '--';
        try {
            const parts = dateString.split(' ')[0].split('-');
            if (parts.length < 3) return dateString;
            const y = parts[0];
            const m = parseInt(parts[1]) - 1;
            const d = parts[2];
            const months = ['enero','febrero','marzo','abril','mayo','junio','julio','agosto','septiembre','octubre','noviembre','diciembre'];
            return `${d} de ${months[m]} ${y}`;
        } catch { return dateString.split(' ')[0] || '--'; }
    };
    
    searchInput.addEventListener('input', (e) => {
        const val = e.target.value.trim();
        clearTimeout(debounceTimer);
        dropdown.innerHTML = '';
        dropdown.classList.add('hidden');
        if(val.length < 2) return;
        inputLoading.classList.remove('hidden');

        debounceTimer = setTimeout(() => {
            fetch(`db/search-staff-profile.php?q=${encodeURIComponent(val)}`)
                .then(res => res.json())
                .then(data => {
                    inputLoading.classList.add('hidden');
                    renderDropdown(data);
                })
                .catch(err => {
                     inputLoading.classList.add('hidden');
                     console.error(err);
                });
        }, 300);
    });
    
    function renderDropdown(list) {
        if(!list || list.length === 0) return;
        dropdown.classList.remove('hidden');
        list.forEach(item => {
            const div = document.createElement('div');
            div.className = "result-item p-3 border-b border-gray-100 flex justify-between items-center";
            div.innerHTML = `<div><div class="font-bold text-gray-800 uppercase">${item.first_name} ${item.last_name}</div><div class="text-md text-gray-500">${item.company || 'Staff'} </div></div><span class="text-lg font-black px-2 py-1 rounded bg-blue-100 text-blue-700">ID: ${item.badge}</span>`;
            div.addEventListener('click', () => {
                dropdown.classList.add('hidden');
                searchInput.value = item.first_name + ' ' + item.last_name;
                startFBILoading(item.id);
            });
            dropdown.appendChild(div);
        });
    }

    function startFBILoading(id) {
        fbiScreen.classList.remove('hidden');
        profileView.classList.add('hidden');
        fetch(`db/get-staff-profile.php?id=${id}`)
            .then(res => res.json())
            .then(data => {
                setTimeout(() => {
                    if(data.error) { alert(`Error: ${data.error}`); fbiScreen.classList.add('hidden'); return; }
                    renderProfileData(data);
                    fbiScreen.classList.add('hidden');
                    profileView.classList.remove('hidden');
                    if(typeof lucide !== 'undefined') lucide.createIcons();
                }, 1000); 
            })
            .catch(error => { alert(`Error de red: ${error.message}`); fbiScreen.classList.add('hidden'); });
    }

    function renderProfileData(data) {
        const p = data.profile;
        const f = data.financials;
        const formatDate = formatDateUserFriendly;

        // --- CABECERA ---
        document.getElementById('p-name').innerText = `${p.full_name}`;
        document.getElementById('p-company').innerText = p.job_title || 'Staff';
        document.getElementById('p-rating').innerText = data.rating_avg + '/5';
        document.getElementById('p-awards').innerText = data.awards_count;
        document.getElementById('p-emp-code').innerText = p.employee_code || '--';

        // Foto
        const imgEl = document.getElementById('p-photo-img');
        const initEl = document.getElementById('p-initials');
        if(p.photo && p.photo.length > 5) {
            imgEl.src = p.photo; imgEl.classList.remove('hidden'); initEl.classList.add('hidden');
        } else {
            imgEl.classList.add('hidden'); initEl.classList.remove('hidden');
            initEl.innerText = p.full_name.substring(0,2).toUpperCase();
        }

        // --- CONTACTO ---
        document.getElementById('p-email').innerText = p.email || '--';
        document.getElementById('p-phone-main').innerText = p.phone || '--';
        document.getElementById('p-mobile').innerText = p.working_days || '--';
        document.getElementById('p-schedule').innerText = p.schedule || 'Sin horario';
        document.getElementById('p-address').innerText = p.status || '--';
        document.getElementById('p-access-code').innerText = p.access_code || '--';
        document.getElementById('p-code-creation').innerText = `CONTRATADO: ${formatDate(p.hired_date).toUpperCase()}`;

        // --- FINANZAS ---
        document.getElementById('p-total-spent').innerText = f.earnings; 
        document.getElementById('p-total-due').innerText = f.hours_worked; 
        document.getElementById('p-total-estimated').innerText = f.salary; 
        document.getElementById('p-salary-display').innerText = '$' + f.salary;

        // --- LISTAS ---
        const fill = (id, arr, fn, msg) => {
            const el = document.getElementById(id); el.innerHTML = '';
            if(!arr || arr.length === 0) { el.innerHTML = `<div class='text-gray-400 italic text-md'>${msg}</div>`; return; }
            arr.forEach(i => el.innerHTML += fn(i));
        };

        // Ruta
        if (data.route_info) {
            document.getElementById('list-route').innerHTML = `<div class="p-2 bg-[var(--color-highlight)]/[0.2] text-[var(--color-primary)] text-md rounded font-bold">${data.route_info.route_name} (${data.route_info.route_day})</div>`;
        } else {
            document.getElementById('list-route').innerHTML = '<div class="text-gray-400 italic text-md">Sin ruta asignada.</div>';
        }

        // --- SECCIONES CORREGIDAS ---
        
        // 1. Clientes (Va en el contenedor list-clients)
        fill('list-clients', data.clients, c => `<div class='flex justify-between border-b border-gray-100 py-2 items-center'><span class='font-bold text-gray-700 text-md'>${c.first_name} ${c.last_name}</span><span class='text-xs text-gray-500'>${c.street_address}</span></div>`, 'Sin clientes asignados.');

        // 2. Citas (Va en el contenedor list-appointments)
        fill('list-appointments', data.appointments, a => `<div class='flex justify-between border-b border-gray-100 py-2 items-center'><div class='flex flex-col'><span class='font-bold text-md text-gray-700'>${formatDate(a.appointment_date)}</span><span class='text-xs text-blue-600 font-bold'>${a.client_name}</span></div><span class='text-xs uppercase bg-gray-100 px-2 py-1 rounded'>${a.status}</span></div>`, 'Sin citas asignadas.');

        // 3. Quejas (Va en el contenedor list-complaints)
        fill('list-complaints', data.complaints, c => `<div class='p-2 bg-red-50 text-red-700 text-md rounded font-bold mb-1 border border-red-100'>${c.title} <span class='font-normal text-xs float-right'>${formatDate(c.created_at)}</span></div>`, 'Sin quejas registradas.');

        // 4. Videos (Va en el contenedor list-videos)
        fill('list-videos', data.videos, v => `<div class='p-2 bg-gray-50 rounded border-b flex justify-between items-center text-sm'><span><i data-lucide='video' class='w-4 inline mr-2 text-red-500'></i>${v.title}</span><span class='text-xs text-gray-400'>${formatDate(v.created_at)}</span></div>`, 'Sin videos disponibles.');

        // 5. Documentos (Va en el contenedor list-documents)
        fill('list-documents', data.documents, d => `<div class='p-2 bg-gray-50 rounded border-b flex justify-between items-center text-sm'><span><i data-lucide='file-text' class='w-4 inline mr-2 text-blue-500'></i>${d.file_name}</span><span class='text-xs text-gray-400'>${formatDate(d.uploaded_at)}</span></div>`, 'Sin documentos.');

        // 6. Reseñas
        fill('list-reviews', data.reviews, r => `
            <div class="p-4 bg-gray-50 rounded-lg border border-gray-200 mb-2">
                <div class="flex gap-1 mb-1">${'<i data-lucide="star" class="w-4 h-4 text-yellow-400 fill-yellow-400"></i>'.repeat(parseInt(r.client_rating))}</div>
                <p class="italic text-gray-700 text-md">"${r.client_feedback || 'Sin comentario'}"</p>
                <span class="block text-xs text-gray-500 mt-2 font-bold">${formatDate(r.appointment_date)}</span>
            </div>
        `, 'Sin reseñas.');
    }
</script>
</body>
</html>