<?php
// CARGA MAESTRA DE CONFIGURACIÓN Y BRANDING
require_once(__DIR__ . '/core/init.php');

$company_name = 'Su Negocio Local';
$owner_name = 'Propietario';
$db_error_message = null;

try {
    $stmt_config = $pdo->prepare("SELECT full_name, company_name FROM business_info WHERE id = 1");
    $stmt_config->execute();
    $config = $stmt_config->fetch(PDO::FETCH_ASSOC);

    if ($config) {
        $company_name = htmlspecialchars($config['company_name'] ?? 'Su Negocio Local', ENT_QUOTES, 'UTF-8');
        $owner_name = htmlspecialchars($config['full_name'] ?? 'Propietario', ENT_QUOTES, 'UTF-8');
        $first_name_parts = explode(' ', $owner_name);
        $owner_first_name = $first_name_parts[0];
    } else {
        $owner_first_name = 'Propietario';
    }
    
} catch (PDOException $e) {
    error_log("Error PDO al cargar configuración para personalización: " . $e->getMessage());
    $db_error_message = 'Error de Base de Datos al cargar la configuración.';
    $owner_first_name = 'Propietario';
} catch (Exception $e) {
    error_log("Error general al cargar configuración para personalización: " . $e->getMessage());
    $owner_first_name = 'Propietario'; 
}

if (ob_get_level() > 0) {
    ob_end_clean();
}

$intro_description = "El Marketing Emocional es y siempre debe ser la estrategia de <b>" . $company_name . "</b> para conectar con los clientes y futuros clientes a nivel personal. En lugar de enfocarse solo en las características de nuestros productos y servicios, apela a lo que el cliente <b>valora, necesita y desea</b>. En un mercado saturado, la emoción es lo que diferencia a su negocio y construye lealtad.";
$conclusion_text = "Las decisiones de adquirir un producto o servicio no siempre son lógicas, <b>" . $owner_first_name . "</b>. A menudo se basan en cómo <b>" . $company_name . "</b> hace sentir al cliente. Al conectar con sus emociones, no solo aumenta la probabilidad de venta, sino que fortalece la <b>fidelidad y el compromiso</b> a largo plazo.";
$owner_mention_1 = "<b>" . $owner_first_name . "</b>, su objetivo principal es hacer que los clientes ideales se sientan <b>comprendidos y valorados</b>.";
$owner_mention_2 = "Recuerde, <b>" . $owner_first_name . "</b>, un cliente emocionalmente conectado es su mejor promotor.";
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <title>Manual De Crecimiento #7 El Marketing Emocional <?php echo htmlspecialchars($branding['full_title']); ?></title>
    <meta name="robots" content="noindex, nofollow">
    
    <link rel="icon" type="image/png" href="<?php echo htmlspecialchars($branding['favicon']); ?>">
    <link rel="apple-touch-icon" href="<?php echo htmlspecialchars($branding['favicon']); ?>">
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="<?php echo htmlspecialchars($google_font_url); ?>">

    <?php include 'files/gtm-head.php'; ?>
    
    <script src="https://unpkg.com/lucide@latest"></script>
    <link rel="stylesheet" href="style.css"> 
    <script src="files/header-manager.js"></script>

    <style>
        .content-card h2, .content-card h3 { text-transform: uppercase; }
        .video-widget { position: relative; background-color: var(--color-primary); color: white; padding: 2rem; border-radius: 1rem; overflow: hidden; }
        .video-widget .blob { position: absolute; width: 150px; height: 150px; border-radius: 50%; filter: blur(50px); opacity: 0.3; }
        .video-widget .bl1 { top: -20px; left: -20px; background-color: var(--color-highlight); }
        .video-widget .bl2 { bottom: -20px; right: -20px; background-color: var(--color-secondary); }
        .content-card h3 { font-size: 1.1rem; }
        .color-brand-success { color: var(--color-secondary); }
        .color-brand-action { color: var(--color-highlight); }
    </style>

</head>
<body data-page-title="Manual De Crecimiento #7 El Marketing Emocional" 
      data-page-subtitle="Análisis Estratégico Para Conectar y Persuadir" 
      data-page-icon="heart-handshake">
    
            <div id="toast-container" class="toast-container"></div>
    
<?php include 'files/gtm-body.php'; ?> 

<div class="relative min-h-screen md:flex">
    <div id="sidebar-overlay" class="fixed inset-0 bg-black bg-opacity-50 z-30 hidden md:hidden"></div>
    <div id="task-panel-overlay" class="fixed inset-0 bg-black/60 z-40 hidden transition-opacity duration-300"></div>  
    
    <?php include 'adn-menu.php'; ?>

    <main class="flex-1 overflow-y-auto">
        <header class="bg-white shadow-sm p-4 flex justify-between items-center sticky top-0 z-20">
            <button id="mobile-menu-button" class="md:hidden text-gray-600 hover:text-gray-800">
                <i data-lucide="menu" class="w-6 h-6"></i>
            </button>
            <div class="page-header-container">
                <h2 id="page-title"></h2>
                <p id="page-subtitle"></p>
            </div>
            <div class="show-widget-container hidden flex justify-end p-0" id="show-acquisition-video-container">
                <button class="show-widget-btn inline-flex items-center gap-3 text-base font-bold text-white bg-[var(--color-primary)] rounded-lg shadow-lg shadow-[var(--color-primary)]/20 py-2 px-4 transform hover:-translate-y-0.5 transition-all duration-300 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-[var(--color-secondary)]"
                        data-widget-id="acquisition-video-widget">
                    <i data-lucide="eye" class="w-5 h-5"></i>
                    <span>ESCUCHAR AUDIO</span>
                </button>
            </div>
        </header>

    <div id="content-area" class="p-4 md:p-8 space-y-8">

    <section class="p-6 md:p-10 video-widget" id="emotional-video-widget">
    <div class="blob bl1"></div><div class="blob bl2"></div>
    <div class="relative grid grid-cols-1 lg:grid-cols-2 gap-8 items-center">
        <div class="lg:col-span-1">
            <span class="chip"><i data-lucide="mic" class="w-4 h-4"></i> Manual De Crecimiento Empresarial</span>
            <h2 class="mt-3 text-2xl md:text-5xl font-black uppercase leading-tight text-[var(--color-highlight)]">Cómo Implementar el Marketing Emocional</h2>
            <h2 class="mt-3 text-2xl md:text-4xl font-black uppercase leading-tight text-white">Para Crear una Marca Inolvidable En El Mercado</h2>
            <p class="mt-2 text-white/90 max-w-xl">Aprenda el viaje de 3 fases (Problema, Solución, Servicio) para motivar las decisiones de sus clientes, <b><?php echo $owner_first_name; ?></b>.</p>
        </div>
        <div class="lg:col-span-1">
            <div class="w-full">
                <div class="bg-black/40 rounded-xl ring-1 ring-white/10 overflow-hidden">
                    <div class="relative w-full" style="padding-bottom: 56.25%;">
                        <img src="img/vids/VideoLeccion-Dashboard.webp" alt="Portada de audio - Marketing Emocional" class="absolute top-0 left-0 w-full h-full object-cover rounded-t-xl">
                    </div>
                    <div class="p-4 bg-black/50">
                        <audio class="w-full" id="emotionalAudioPlayer" controls controlslist="nodownload" preload="metadata">
                            <source src="https://www.soundhelix.com/examples/mp3/SoundHelix-Song-1.mp3" type="audio/mp3">
                            TU NAVEGADOR NO SOPORTA LA ETIQUETA DE AUDIO
                        </audio>
                    </div>
                    <div class="p-4 text-white/90 text-sm flex items-center justify-between border-t border-white/10">
                        <span class="inline-flex items-center gap-2">
                            <i data-lucide="headphones" class="w-4 h-4"></i>
                            Escucha La Lección Explicativa
                        </span>
                            <button class="hide-widget-btn inline-flex items-center gap-2 text-xs font-black text-[var(--color-highlight)] hover:text-white transition-colors py-1 px-2 rounded-md" 
                                    data-widget-id="emotional-video-widget" title="Ocultar el audio explicativo">
                                OCULTAR AUDIO
                                <i data-lucide="square-x" class="w-4 h-4"></i>
                            </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

    <div class="bg-white p-6 rounded-xl border-l-4 border-[var(--color-primary)] transition content-card shadow-md">
        <div class="flex items-center">
            <i data-lucide="heart-handshake" class="w-10 h-10 mr-4 text-[var(--color-highlight)]"></i>
            <div>
                <h1 class="text-3xl md:text-5xl font-black text-[var(--color-primary)]">EL MARKETING EMOCIONAL</h1>
                <p class="text-lg font-semibold uppercase text-[var(--color-secondary)]">ANÁLISIS ESTRATÉGICO PARA <b><?php echo $company_name; ?></b></p>
            </div>
        </div>
        <div class="mt-4 text-lg text-gray-700 pl-14 space-y-3">
             <p><?php echo $intro_description; ?></p>
             <p class="text-lg font-semibold text-[var(--color-secondary)]"><b><?php echo $owner_mention_1; ?></b></p>
        </div>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
        
        <div class="bg-white p-6 rounded-xl border-l-4 border-[var(--color-highlight)] content-card shadow-md">
            <div class="flex items-center mb-4">
                <i data-lucide="brain" class="w-8 h-8 mr-3 text-[var(--color-secondary)]"></i>
                <div>
                    <h2 class="text-3xl font-black text-[var(--color-primary)]">FUNCIONES PRINCIPALES</h2>
                    <p class="text-sm font-bold uppercase text-[var(--color-secondary)]">Los Pilares de la Estrategia Publicitaria</p>
                </div>
            </div>
            <ul class="space-y-2 text-gray-700 text-lg">
                <li class="flex items-start"><i data-lucide="square-check-big" class="w-5 h-5 mr-3 mt-1 flex-shrink-0 color-brand-success"></i><span><b>Conexión Emocional:</b> Hacer que el cliente potencial se sienta comprendido y valorado.</span></li>
                <li class="flex items-start"><i data-lucide="square-check-big" class="w-5 h-5 mr-3 mt-1 flex-shrink-0 color-brand-success"></i><span><b>Diferenciación:</b> Destacar en un mercado saturado apelando a las emociones para presentar la solución.</span></li>
                <li class="flex items-start"><i data-lucide="square-check-big" class="w-5 h-5 mr-3 mt-1 flex-shrink-0 color-brand-success"></i><span><b>Fidelización:</b> Crear lazos más fuertes que las decisiones lógicas, llevando a mayor lealtad.</span></li>
                <li class="flex items-start"><i data-lucide="square-check-big" class="w-5 h-5 mr-3 mt-1 flex-shrink-0 color-brand-success"></i><span><b>Motivación:</b> Usar la emoción como el impulsor de la acción (compra, recomendación).</span></li>
                <li class="flex items-start"><i data-lucide="square-check-big" class="w-5 h-5 mr-3 mt-1 flex-shrink-0 color-brand-success"></i><span><b>Reforzar Valores:</b> Generar una comunidad de clientes con creencias similares.</span></li>
            </ul>
        </div>

        <div class="bg-white p-6 rounded-xl border-l-4 border-[var(--color-highlight)] content-card shadow-md">
            <div class="flex items-center mb-4">
                <i data-lucide="trending-up" class="w-8 h-8 mr-3 text-[var(--color-secondary)]"></i>
                <div>
                    <h2 class="text-3xl font-black text-[var(--color-primary)]">SU GRAN IMPORTANCIA</h2>
                    <p class="text-sm font-bold uppercase text-[var(--color-secondary)]">Por Qué Funciona Esta Estrategia</p>
                </div>
            </div>
            <ul class="space-y-2 text-gray-700 text-lg">
                <li class="flex items-start"><i data-lucide="square-check-big" class="w-5 h-5 mr-3 mt-1 flex-shrink-0 color-brand-success"></i><span>Las personas toman <b>decisiones basadas en emociones</b>, más que en lógica.</span></li>
                <li class="flex items-start"><i data-lucide="square-check-big" class="w-5 h-5 mr-3 mt-1 flex-shrink-0 color-brand-success"></i><span>Crea <b>relaciones duraderas</b> y profundas, no únicamente de compra.</span></li>
                <li class="flex items-start"><i data-lucide="square-check-big" class="w-5 h-5 mr-3 mt-1 flex-shrink-0 color-brand-success"></i><span>Los clientes conectados son más propensos a <b>recomendar el negocio y sus servicios</b>.</span></li>
                <li class="flex items-start"><i data-lucide="square-check-big" class="w-5 h-5 mr-3 mt-1 flex-shrink-0 color-brand-success"></i><span>Es una <b>ventaja competitiva</b> clave cuando los servicios son similares.</span></li>
                <li class="flex items-start"><i data-lucide="square-check-big" class="w-5 h-5 mr-3 mt-1 flex-shrink-0 color-brand-success"></i><span>Aumenta el <b>valor percibido</b> del servicio y de todo el negocio.</span></li>
            </ul>
        </div>
    </div>
    
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
        
        <div class="bg-white p-6 rounded-xl border-l-4 border-[var(--color-highlight)] content-card shadow-md">
            <div class="mb-4 border-b pb-3">
                <div class="flex items-center">
                    <i data-lucide="frown" class="w-8 h-8 mr-3 text-[var(--color-secondary)]"></i>
                    <h2 class="text-3xl font-black text-[var(--color-primary)]">FASE 1: <br />EL PROBLEMA</h2>
                </div>
                <p class="text-sm font-bold uppercase text-[var(--color-secondary)]">Enfoque: Tristeza y Empatía</p>
            </div>
            <div class="space-y-4">
                <p class="text-gray-600 text-lg">Tu objetivo es conectar con la frustración actual del cliente ideal. No vendas, solo crea una conexión emocional de comprensión. <br /><br />El mensaje debe hacer que el cliente piense: "Ese soy yo, entienden mi problema". Usa un lenguaje que refleje su agobio y preocupación.</p>
                <div>
                    <h3 class="font-black text-[var(--color-secondary)]">Las Emociones del Problema</h3>
                    <p class="text-gray-600 text-lg mt-2">En esta fase, el cliente potencial se siente dominado por la <b>frustración</b>; vive con una sensación de agobio, sintiéndose atrapado o limitado por su problema. <br /><br />Esto genera <b>ansiedad y desesperanza</b>, manifestada en miedos y preocupaciones intensas sobre cómo y cuándo lo resolverá. <br /><br />Si ha intentado soluciones antes y ha fallado, puede sentir <b>desesperanza</b>, percibiendo que el problema es insuperable. Todo esto lo lleva a un estado de <b>confusión</b>, sin claridad sobre qué camino tomar.</p>
                </div>
            </div>
        </div>

        <div class="bg-white p-6 rounded-xl border-l-4 border-[var(--color-highlight)] content-card shadow-md">
            <div class="mb-4 border-b pb-3">
                <div class="flex items-center">
                    <i data-lucide="meh" class="w-8 h-8 mr-3 text-[var(--color-secondary)]"></i>
                    <h2 class="text-3xl font-black text-[var(--color-primary)]">FASE 2: <br />LA SOLUCIÓN</h2>
                </div>
                <p class="text-sm font-bold uppercase text-[var(--color-secondary)]">Enfoque: Esperanza y Positividad</p>
            </div>
            <div class="space-y-4">
                <p class="text-gray-600 text-lg">Aquí presentas la importancia de tomar acción y buscar la solución. Muestras el camino para salir del problema y del estado actual en que se encuentra. <br /><br />Tu meta es cambiar la emoción de "estoy atrapado" a "existe una esperanza, una mejor manera de hacer esto".</p>
                    <div>
                    <h3 class="font-black text-[var(--color-secondary)]">Las Emociones de la Solución</h3>
                    <p class="text-gray-600 text-lg mt-2">Al presentar una solución creíble, el <b>entusiasmo</b> reemplaza a la desesperanza; el cliente empieza a emocionarse por las nuevas posibilidades que se abren. <br /><br />Esta esperanza se convierte rápidamente en <b>confianza</b>, la sensación de que por fin está en el camino correcto y que está tomando una decisión adecuada para salir de su problema y de su estado actual de insatisfacción del que quiere alejarse.</p>
                </div>
            </div>
        </div>
        
        <div class="bg-white p-6 rounded-xl border-l-4 border-[var(--color-highlight)] content-card shadow-md">
            <div class="mb-4 border-b pb-3">
                <div class="flex items-center">
                    <i data-lucide="smile" class="w-8 h-8 mr-3 text-[var(--color-secondary)]"></i>
                    <h2 class="text-3xl font-black text-[var(--color-primary)]">FASE 3: <br />EL SERVICIO</h2>
                </div>
                <p class="text-sm font-bold uppercase text-[var(--color-secondary)]">Enfoque: Alegría y Confianza</p>
            </div>
            <div class="space-y-4">
                <p class="text-gray-600 text-lg">Ahora sí. Presentas tu servicio como la mejor implementación de esa solución. Eres el puente de la esperanza a la confianza. <br /><br />Demuestra por qué <b><?php echo $company_name; ?></b> es la elección lógica y segura para alcanzar ese futuro feliz que el potencial tanto busca.</p>
                    <div>
                    <h3 class="font-black text-[var(--color-secondary)]">Las Emociones del Servicio</h3>
                    <p class="text-gray-600 text-lg mt-2">Al presentar tu servicio como el vehículo para esa solución, el cliente potencial debe sentir <b>alegría</b> o alivio, la sensación de que elegirte es una decisión beneficiosa que le quitará un peso de encima. <br /><br />Esto se transforma en un <b>interés</b> genuino, donde comienza a considerar seriamente a tu negocio como la respuesta definitiva a su problema.</p>
                </div>
            </div>
        </div>

    </div>


    <div class="bg-[var(--color-primary)] p-6 rounded-xl ">
        <div class="flex items-center mb-4">
           <i data-lucide="trending-up" class="w-8 h-8 mr-3 text-[var(--color-highlight)]"></i>
            <h2 class="text-4xl font-black text-[var(--color-highlight)]">CONCLUSIÓN ESTRATÉGICA</h2>
        </div>
        <p class="text-white/90 text-lg">
            <?php echo $conclusion_text; ?>
        </p>
        <p class="text-white/80 text-lg mt-4 text-right"><b><?php echo $owner_mention_2; ?></b></p>
    </div>

    </div> </main>
    
    <script>
    (function() {
        // --- Lógica del Widget de Audio (Adaptada) ---
        const audioPlayer = document.getElementById('emotionalAudioPlayer');
        const widget = document.getElementById('emotional-video-widget');
        const showContainer = document.getElementById('show-emotional-video-container');
        const widgetKey = 'hide_emotional-video-widget'; // Clave única para este widget

        const toggleWidgetVisibility = (isHidden) => {
            if (!widget || !showContainer) return; 

            if (isHidden) {
                widget.classList.add('hidden');
                showContainer.classList.remove('hidden');
                if (audioPlayer) audioPlayer.pause(); 
            } else {
                widget.classList.remove('hidden');
                showContainer.classList.add('hidden');
            }
            localStorage.setItem(widgetKey, isHidden ? 'true' : 'false');
        };
        
        // --- Lógica de Document Ready ---
        document.addEventListener('DOMContentLoaded', () => {
            // Lógica del Menú Móvil
            const mobileMenuButton = document.getElementById('mobile-menu-button');
            const sidebar = document.getElementById('sidebar');
            const sidebarOverlay = document.getElementById('sidebar-overlay');
            if (mobileMenuButton && sidebar && sidebarOverlay) { 
                mobileMenuButton.addEventListener('click', () => { 
                    sidebar.classList.toggle('-translate-x-full'); 
                    sidebarOverlay.classList.toggle('hidden'); 
                }); 
                sidebarOverlay.addEventListener('click', () => { 
                    sidebar.classList.add('-translate-x-full'); 
                    sidebarOverlay.classList.add('hidden'); 
                }); 
            }

            // Botones Ocultar/Mostrar para el widget de este documento
            document.querySelector('.hide-widget-btn[data-widget-id="emotional-video-widget"]')?.addEventListener('click', () => toggleWidgetVisibility(true));
            document.querySelector('.show-widget-btn[data-widget-id="emotional-video-widget"]')?.addEventListener('click', () => toggleWidgetVisibility(false));

            // Chequeo del estado inicial
            const isHidden = localStorage.getItem(widgetKey) === 'true';
            toggleWidgetVisibility(isHidden);

            // Inicializar Iconos Lucide
            lucide.createIcons();
        });
    })();
    </script>
<script src="files/toast.js"></script>
</body>
</html>