<?php
// CARGA MAESTRA DE CONFIGURACIÓN Y BRANDING
require_once(__DIR__ . '/core/init.php');

$company_name = 'Su Negocio Local';
$owner_name = 'Propietario';
$db_error_message = null;

try {
    $stmt_config = $pdo->prepare("SELECT full_name, company_name FROM business_info WHERE id = 1");
    $stmt_config->execute();
    $config = $stmt_config->fetch(PDO::FETCH_ASSOC);

    if ($config) {
        $company_name = htmlspecialchars($config['company_name'] ?? 'Su Negocio Local', ENT_QUOTES, 'UTF-8');
        $owner_name = htmlspecialchars($config['full_name'] ?? 'Propietario', ENT_QUOTES, 'UTF-8');
        $first_name_parts = explode(' ', $owner_name);
        $owner_first_name = $first_name_parts[0];
    } else {
        $owner_first_name = 'Propietario';
    }
    
} catch (PDOException $e) {
    error_log("Error PDO al cargar configuración para personalización: " . $e->getMessage());
    $db_error_message = 'Error de Base de Datos al cargar la configuración.';
    $owner_first_name = 'Propietario';
} catch (Exception $e) {
    error_log("Error general al cargar configuración para personalización: " . $e->getMessage());
    $owner_first_name = 'Propietario'; 
}

if (ob_get_level() > 0) {
    ob_end_clean();
}

$intro_description = "El problema de la mayoría de los dueños de negocios locales es que se comunican de la misma forma con todas las personas. Su cliente potencial se encuentra en diferentes <b>etapas mentales de consciencia</b>, y si usted le ofrece la solución (lo que su negocio provee) a alguien que ni siquiera sabe que tiene un problema, solo generará <b>ruido y ningún impacto</b>. Los niveles de consciencia son su <b>Mapa de la Mente del Cliente Potencial</b> para saber <b>qué decir</b>, <b>cuándo decirlo</b> y <b>cómo</b> generar esa conexión inconsciente que disuelve las objeciones.";
$conclusion_text = "Esta estrategia no se trata de gastar más dinero en publicidad, sino de ser <b>inteligente y empático</b> con lo que ya está invirtiendo. Al ajustar su comunicación para cada nivel, usted puede <b>educar al cliente ideal</b>, <b>construir confianza</b> y posicionar su negocio como la <b>mejor opción</b>, asegurando la solución adecuada en el momento justo.";
$owner_mention_1 = "Recuerde, <b>" . $owner_first_name . "</b>: no buscamos únicamente convencer, primero buscamos guiar.";
$owner_mention_2 = "Para guiar a alguien, <b>" . $owner_first_name . "</b>, lo primero es saber desde dónde está comenzando su camino.";

?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <title>Manual De Crecimiento #1 Los Niveles De Consciencia <?php echo htmlspecialchars($branding['full_title']); ?></title>
    <meta name="robots" content="noindex, nofollow">
    
    <link rel="icon" type="image/png" href="<?php echo htmlspecialchars($branding['favicon']); ?>">
    <link rel="apple-touch-icon" href="<?php echo htmlspecialchars($branding['favicon']); ?>">
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="<?php echo htmlspecialchars($google_font_url); ?>">

    <?php include 'files/gtm-head.php'; ?>
    
    <script src="https://unpkg.com/lucide@latest"></script>
    <link rel="stylesheet" href="style.css"> 
    <script src="files/header-manager.js"></script>

    <style>
        .content-card h2, .content-card h3 { text-transform: uppercase; }
        .video-widget { position: relative; background-color: var(--color-primary); color: white; padding: 2rem; border-radius: 1rem; overflow: hidden; }
        .video-widget .blob { position: absolute; width: 150px; height: 150px; border-radius: 50%; filter: blur(50px); opacity: 0.3; }
        .video-widget .bl1 { top: -20px; left: -20px; background-color: var(--color-highlight); }
        .video-widget .bl2 { bottom: -20px; right: -20px; background-color: var(--color-secondary); }
    </style>

</head>
<body data-page-title="Manual De Crecimiento #1 Los Niveles De Consciencia" 
      data-page-subtitle="Análisis Estratégico De La Consciencia Del Cliente" 
      data-page-icon="brain-circuit">
    
            <div id="toast-container" class="toast-container"></div>
    
<?php include 'files/gtm-body.php'; ?> 

<div class="relative min-h-screen md:flex">
    <div id="sidebar-overlay" class="fixed inset-0 bg-black bg-opacity-50 z-30 hidden md:hidden"></div>
    <div id="task-panel-overlay" class="fixed inset-0 bg-black/60 z-40 hidden transition-opacity duration-300"></div>  
    
    <?php include 'adn-menu.php'; ?>

    <main class="flex-1 overflow-y-auto">
        <header class="bg-white shadow-sm p-4 flex justify-between items-center sticky top-0 z-20">
            <button id="mobile-menu-button" class="md:hidden text-gray-600 hover:text-gray-800">
                <i data-lucide="menu" class="w-6 h-6"></i>
            </button>
            <div class="page-header-container">
                <h2 id="page-title"></h2>
                <p id="page-subtitle"></p>
            </div>
            <div class="show-widget-container hidden flex justify-end p-0" id="show-acquisition-video-container">
                <button class="show-widget-btn inline-flex items-center gap-3 text-base font-bold text-white bg-[var(--color-primary)] rounded-lg shadow-lg shadow-[var(--color-primary)]/20 py-2 px-4 transform hover:-translate-y-0.5 transition-all duration-300 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-[var(--color-secondary)]"
                        data-widget-id="acquisition-video-widget">
                    <i data-lucide="eye" class="w-5 h-5"></i>
                    <span>ESCUCHAR AUDIO</span>
                </button>
            </div>
        </header>

    <div id="content-area" class="p-4 md:p-8 space-y-8">

    <section class="p-6 md:p-10 video-widget" id="awareness-video-widget">
    <div class="blob bl1"></div><div class="blob bl2"></div>
    <div class="relative grid grid-cols-1 lg:grid-cols-2 gap-8 items-center">
        <div class="lg:col-span-1">
            <span class="chip"><i data-lucide="mic" class="w-4 h-4"></i> Manual De Crecimiento Empresarial</span>
            <h2 class="mt-3 text-2xl md:text-5xl font-black uppercase leading-tight text-[var(--color-highlight)]">Cómo Implementar Los Niveles de Consciencia</h2>
            <h2 class="mt-3 text-2xl md:text-4xl font-black uppercase leading-tight text-white">Para Crear Mensajes Que Conecten Con La Audiencia</h2>
            <p class="mt-2 text-white/90 max-w-xl text-lg">Entienda cómo guiar a un cliente desde 'Inconsciente' hasta 'Totalmente Consciente' y aplíquelo en su marketing, <b><?php echo $owner_first_name; ?></b>.</p>
        </div>
        <div class="lg:col-span-1">
            <div class="w-full">
                <div class="bg-black/40 rounded-xl ring-1 ring-white/10 overflow-hidden">
                    <div class="relative w-full" style="padding-bottom: 56.25%;">
                        <img src="img/vids/VideoLeccion-Dashboard.webp" alt="Portada de audio - Niveles de Conciencia" class="absolute top-0 left-0 w-full h-full object-cover rounded-t-xl">
                    </div>
                    <div class="p-4 bg-black/50">
                        <audio class="w-full" id="awarenessAudioPlayer" controls controlslist="nodownload" preload="metadata">
                            <source src="adn/awareness-levels.mp3" type="audio/mp3">
                            SU NAVEGADOR NO SOPORTA LA ETIQUETA DE AUDIO
                        </audio>
                    </div>
                    <div class="p-4 text-white/90 text-sm flex items-center justify-between border-t border-white/10">
                        <span class="inline-flex items-center gap-2">
                            <i data-lucide="headphones" class="w-4 h-4"></i>
                            Escucha La Lección Explicativa
                        </span>
                            <button class="hide-widget-btn inline-flex items-center gap-2 text-xs font-black text-[var(--color-highlight)] hover:text-white transition-colors py-1 px-2 rounded-md" 
                                    data-widget-id="awareness-video-widget" title="Ocultar el audio explicativo">
                                OCULTAR AUDIO
                                <i data-lucide="square-x" class="w-4 h-4"></i>
                            </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

    <div class="bg-white p-6 rounded-xl border-l-4 border-[var(--color-primary)] transition content-card shadow-md">
        <div class="flex items-center">
            <i data-lucide="brain-circuit" class="w-10 h-10 mr-4 text-[var(--color-highlight)]"></i>
            <div>
                <h1 class="text-3xl md:text-5xl font-black text-[var(--color-primary)]">LOS NIVELES DE CONSCIENCIA</h1>
                <p class="text-lg font-semibold uppercase text-[var(--color-secondary)]">ANÁLISIS ESTRATÉGICO PARA <b><?php echo $company_name; ?></b></p>
            </div>
        </div>
        <div class="mt-4 text-lg text-gray-700 pl-14 space-y-3">
             <p><?php echo $intro_description; ?></p>
             <p class="text-md font-semibold text-[var(--color-secondary)]"><b><?php echo $owner_mention_1; ?></b></p>
        </div>
    </div>
    
    <div class="bg-white p-6 rounded-xl content-card shadow-md">
        <div class="flex items-center mb-4 border-b pb-3">
            <i data-lucide="moon" class="w-8 h-8 mr-3 text-[var(--color-highlight)]"></i>
            <div>
                <h2 class="text-3xl font-black text-[var(--color-primary)]">NIVEL 1: TOTALMENTE INCONSCIENTE</h2>
                <p class="text-sm font-bold uppercase text-[var(--color-secondary)]">SU CLIENTE IDEAL NO SABE O NO COMPRENDE QUE TIENE UN PROBLEMA</p>
            </div>
        </div>
        <div class="space-y-4">
            <div>
                <p class="text-gray-600 text-lg">En esta etapa, el cliente ideal está <b>ciego a su propio problema</b>. Piensa que su frustración, desorden o estancamiento es normal o "así es la vida". Está resignado y no busca soluciones.</p>
            </div>
            <div>
                <h3 class="font-black text-[var(--color-secondary)]">Objetivo</h3>
                <p class="text-gray-600 text-lg"><b>Despertarlo De Su Estado Actual.</b> Sembrar una <b>duda poderosa sobre su estado actual</b> que rompa su normalidad y active el pensamiento de: "Un momento, mi situación no tiene por qué ser así."</p>
            </div>
            <div>
                <h3 class="font-black text-[var(--color-secondary)]">A qué Apelar</h3>
                <p class="text-gray-600 text-lg">A la <b>frustración latente</b> que no percibe. Recuérdele lo que está perdiendo (tiempo, paz mental, energía) por seguir igual. Describa el Costo de no hacer nada y permanecer sin cambios.</p>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6 pt-4">
                <div class="bg-black/10 p-4 rounded-lg border border-[var(--color-secondary)]">
                    <h3 class="text-2xl font-black text-[var(--color-secondary)] flex items-center mb-2"><i data-lucide="check-circle" class="w-5 h-5 mr-2"></i>QUÉ DEBEMOS HACER</h3>
                    <ul class="list-none space-y-2 text-gray-700 text-lg">
                         <li class="flex items-start"><i data-lucide="check" class="w-4 h-4 mr-2 mt-1 flex-shrink-0 text-[var(--color-secondary)]"></i><span><b class="font-black">Identificar El Patrón:</b> Describir la vida que lleva sin la solución.</span></li>
                         <li class="flex items-start"><i data-lucide="check" class="w-4 h-4 mr-2 mt-1 flex-shrink-0 text-[var(--color-secondary)]"></i><span><b class="font-black">Romper La Justificación:</b> Plantear preguntas que rompan su inercia: "¿Eres consciente?"</span></li>
                         <li class="flex items-start"><i data-lucide="check" class="w-4 h-4 mr-2 mt-1 flex-shrink-0 text-[var(--color-secondary)]"></i><span><b class="font-black">Exponer El Costo:</b> Mostrar lo que pierde al no cambiar (tiempo, energía, oportunidades).</span></li>
                         <li class="flex items-start"><i data-lucide="check" class="w-4 h-4 mr-2 mt-1 flex-shrink-0 text-[var(--color-secondary)]"></i><span><b class="font-black">Mensaje Clave:</b> Interrumpir el ciclo automático. Repetir no es estabilidad, es parálisis.</span></li>
                    </ul>
                </div>
                <div class="bg-black/10 p-4 rounded-lg border border-[var(--color-secondary)]">
                    <h3 class="text-2xl font-black text-[var(--color-secondary)] flex items-center mb-2"><i data-lucide="x-circle" class="w-5 h-5 mr-2"></i>QUÉ DEBEMOS EVITAR</h3>
                    <ul class="list-none space-y-2 text-gray-700 text-lg">
                         <li class="flex items-start"><i data-lucide="x" class="w-4 h-4 mr-2 mt-1 flex-shrink-0 text-[var(--color-secondary)]"></i><span><b class="font-black">No Justificar:</b> Evitar la frase "todos pasan por eso". Eso refuerza la resignación.</span></li>
                         <li class="flex items-start"><i data-lucide="x" class="w-4 h-4 mr-2 mt-1 flex-shrink-0 text-[var(--color-secondary)]"></i><span><b class="font-black">No Vender:</b> No hablar todavía de soluciones o mejoras. Aún no ha visto el problema real.</span></li>
                         <li class="flex items-start"><i data-lucide="x" class="w-4 h-4 mr-2 mt-1 flex-shrink-0 text-[var(--color-secondary)]"></i><span><b class="font-black">No Usar Éxito Aislado:</b> Las historias de éxito crean distancia; el cliente aún no se ve capaz.</span></li>
                         <li class="flex items-start"><i data-lucide="x" class="w-4 h-4 mr-2 mt-1 flex-shrink-0 text-[var(--color-secondary)]"></i><span><b class="font-black">No Corregir:</b> Solo inspirar a que se cuestione su propia vida.</span></li>
                    </ul>
                </div>
            </div>
            
            <div class="pt-4">
                <h3 class="text-2xl font-black text-[var(--color-secondary)]">Cómo Llevarlo Al Siguiente Nivel</h3>
                <p class="text-gray-600 text-lg">La persona avanza cuando ya no puede justificarse y acepta que seguir con su situación actual tiene un costo grave. El dolor es la palanca del cambio.</p>
            </div>

        </div>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
        
        <div class="bg-white p-6 rounded-xl border-l-4 border-[var(--color-secondary)] content-card shadow-md">
            <div class="flex items-center mb-4">
                <i data-lucide="alert-circle" class="w-8 h-8 mr-4 text-[var(--color-highlight)]"></i>
                <div>
                    <h2 class="text-3xl font-black text-[var(--color-primary)]">NIVEL 2: <br />CONSCIENTE DEL PROBLEMA</h2>
                    <p class="text-sm font-bold uppercase text-[var(--color-secondary)]">RECONOCE QUE TIENE UN PROBLEMA Y ESTÁ INQUIETO</p>
                </div>
            </div>
            <p class="text-gray-700 text-lg mb-4">
                El cliente ideal acepta: "Tengo un problema." Siente el dolor y ha comenzado a buscar opciones, pero muchas de estas son genéricas. Aún no sabe qué tipo de solución existe o cuál necesita.
            </p>
            <div class="space-y-4 pt-4 border-t">
                <div>
                    <h3 class="font-black text-[var(--color-secondary)]">Nuestra Estrategia</h3>
                    <p class="text-gray-600 text-lg"><b>Material:</b> Cree <b>Guías Educativas</b> (Artículos, Ebooks, Posts Sociales, etc.) que expliquen las causas y consecuencias del problema, y por qué el <b>Servicio Profesional</b> es una vía de escape viable.</p>
                    <p class="text-gray-600 text-lg mt-2"><b>Mensaje De Conexión:</b> Cree mensajes que conecten con esa necesidad, generen empatía y guíen hacia la solución.</p>
                </div>
                <div>
                    <h3 class="font-black text-[var(--color-secondary)]">Objetivo Estratégico</h3>
                    <p class="text-gray-600 text-lg"><b>Estado Actual:</b> Frustración por no tener tiempo o conocimiento.</p>
                    <p class="text-gray-600 text-lg"><b>Objetivo:</b> <b>Generar Interés</b> mostrando que la solución existe y que le permitirá <b>recuperar tiempo y tranquilidad.</b></p>
                </div>
            </div>
        </div>

        <div class="bg-white p-6 rounded-xl border-l-4 border-[var(--color-secondary)] content-card shadow-md">
            <div class="flex items-center mb-4">
                <i data-lucide="search" class="w-8 h-8 mr-4 text-[var(--color-highlight)]"></i>
                <div>
                    <h2 class="text-3xl font-black text-[var(--color-primary)]">NIVEL 3: <br />CONSCIENTE DE LA SOLUCIÓN</h2>
                    <p class="text-sm font-bold uppercase text-[var(--color-secondary)]">SABE QUE EXISTE UNA SOLUCIÓN (PERO NO SABE CUÁL ES LA MEJOR)</p>
                </div>
            </div>
            <p class="text-gray-700 text-lg mb-4">
                El cliente ideal ya sabe que la solución es el <b>tipo de servicio que usted ofrece</b>. Ahora está comparando tipos de soluciones: revisando precio, calidad, etc., para asegurarse de que tomará la decisión correcta.
            </p>
             <div class="space-y-4 pt-4 border-t">
                <div>
                    <h3 class="font-black text-[var(--color-secondary)]">Nuestra Estrategia</h3>
                    <p class="text-gray-600 text-lg"><b>Material:</b> Enfóquese en la <b>Diferenciación de Soluciones</b>. Use <b>casos de estudio</b> y <b>ejemplos de antes y después</b> para que el cliente potencial vea el resultado tangible de su servicio.</p>
                    <p class="text-gray-600 text-lg mt-2"><b>Mensaje De Conexión:</b> <b>"Nuestro servicio se adapta a tu necesidad única</b> con un plan flexible, asegurando que tu problema será resuelto, mientras tú <b>disfrutas de tu vida."</b></p>
                </div>
                <div>
                    <h3 class="font-black text-[var(--color-secondary)]">Objetivo Estratégico</h3>
                    <p class="text-gray-600 text-lg"><b>Estado Actual:</b> Considerando si contratar un servicio es una inversión valiosa.</p>
                    <p class="text-gray-600 text-lg"><b>Objetivo:</b> Demostrar la <b>Consistencia y el Valor a Largo Plazo</b> de su servicio, enfatizando que <b>la inversión merece la pena.</b></p>
                </div>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
        
        <div class="bg-white p-6 rounded-xl border-l-4 border-[var(--color-secondary)] content-card shadow-md">
            <div class="flex items-center mb-4">
                <i data-lucide="list-filter" class="w-8 h-8 mr-4 text-[var(--color-highlight)]"></i>
                <div>
                    <h2 class="text-3xl font-black text-[var(--color-primary)]">NIVEL 4: <br />CONSCIENTE DEL SERVICIO</h2>
                    <p class="text-sm font-bold uppercase text-[var(--color-secondary)]">YA CONOCE EL SERVICIO Y QUIENES LO OFRECEN</p>
                </div>
            </div>
            <p class="text-gray-700 text-lg mb-4">
                Usted está en la mente del cliente potencial. Conoce a <b><?php echo $company_name; ?></b>, pero también a su competencia. Está a punto de decidir y necesita asegurarse de que usted es la opción más segura.
            </p>
            <div class="space-y-4 pt-4 border-t">
                <div>
                    <h3 class="font-black text-[var(--color-secondary)]">Nuestra Estrategia</h3>
                    <p class="text-gray-600 text-lg"><b>Material:</b> Utilice <b>Prueba Social Fuerte</b>: Muestre reseñas, videos de testimonios y un portafolio detallado de su trabajo. Elimine objeciones.</p>
                    <p class="text-gray-600 text-lg mt-2"><b>Mensaje De Conexión:</b> <b>"Decenas de clientes como tú ya han confiado en nosotros para recuperar su paz mental.</b> ¿Listo para tomar acción y vivir sin el problema?"</p>
                </div>
                <div>
                    <h3 class="font-black text-[var(--color-secondary)]">Objetivo Estratégico</h3>
                    <p class="text-gray-600 text-lg"><b>Estado Actual:</b> Indeciso. Necesita superar la desconfianza para tomar la decisión final.</p>
                    <p class="text-gray-600 text-lg"><b>Objetivo:</b> Fortalecer la <b>Confianza</b> y eliminar las últimas dudas con pruebas irrefutables.</p>
                </div>
            </div>
        </div>

        <div class="bg-white p-6 rounded-xl border-l-4 border-[var(--color-secondary)] content-card shadow-md">
            <div class="flex items-center mb-4">
                <i data-lucide="shopping-cart" class="w-8 h-8 mr-4 text-[var(--color-highlight)]"></i>
                <div>
                    <h2 class="text-3xl font-black text-[var(--color-primary)]">NIVEL 5: <br />TOTALMENTE CONSCIENTE</h2>
                    <p class="text-sm font-bold uppercase text-[var(--color-secondary)]">CONOCE SU SERVICIO Y ESTÁ LISTO PARA COMPRAR</p>
                </div>
            </div>
            <p class="text-gray-700 text-lg mb-4">
                Ha elegido a <b><?php echo $company_name; ?></b> y está listo para contratar el servicio o adquirir el producto. El desafío aquí no es convencer, sino no interponerse. Busca la mejor experiencia de adquisición.
            </p>
             <div class="space-y-4 pt-4 border-t">
                <div>
                    <h3 class="font-black text-[var(--color-secondary)]">Nuestra Estrategia</h3>
                    <p class="text-gray-600 text-lg"><b>Material:</b> Ofrecer un <b>método de contratación simple y sin fricciones</b>. Promociones exclusivas y opciones de pago flexibles.</p>
                    <p class="text-gray-600 text-lg mt-2"><b>Mensaje De Conexión:</b> <b>"Es el momento de liberar tu tiempo y recuperar tu vida.</b> Completa tu contratación en 3 simples pasos. <b>¡Empieza hoy!</b>"</p>
                </div>
                <div>
                    <h3 class="font-black text-[var(--color-secondary)]">Objetivo Estratégico</h3>
                    <p class="text-gray-600 text-lg"><b>Estado Actual:</b> Listo(a) para contratar, pero necesita un proceso fácil y sin barreras.</p>
                    <p class="text-gray-600 text-lg"><b>Objetivo:</b> <b>Facilitar al 100% la decisión.</b> Asegurar la mejor experiencia de adquisición para convertir la intención en una <b>venta inmediata</b>.</p>
                </div>
            </div>
        </div>
    </div>


    <div class="bg-[var(--color-primary)] p-6 rounded-xl ">
        <div class="flex items-center mb-4">
           <i data-lucide="trending-up" class="w-8 h-8 mr-3 text-[var(--color-highlight)]"></i>
            <h2 class="text-4xl font-black text-[var(--color-highlight)]">CONCLUSIÓN ESTRATÉGICA</h2>
        </div>
        <p class="text-white/90 text-lg">
            <?php echo $conclusion_text; ?>
        </p>
        <p class="text-white/80 text-md mt-4 text-right"><b><?php echo $owner_mention_2; ?></b></p>
    </div>

    </div> </main>
    
    <script>
    (function() {
        const audioPlayer = document.getElementById('awarenessAudioPlayer');
        const widget = document.getElementById('awareness-video-widget');
        const showContainer = document.getElementById('show-awareness-video-container');
        const widgetKey = 'hide_awareness-video-widget'; // Clave única para este widget

        const toggleWidgetVisibility = (isHidden) => {
            if (!widget || !showContainer) return; 

            if (isHidden) {
                widget.classList.add('hidden');
                showContainer.classList.remove('hidden');
                if (audioPlayer) audioPlayer.pause(); 
            } else {
                widget.classList.remove('hidden');
                showContainer.classList.add('hidden');
            }
            localStorage.setItem(widgetKey, isHidden ? 'true' : 'false');
        };
        
        // --- Lógica de Document Ready ---
        document.addEventListener('DOMContentLoaded', () => {
            // Lógica del Menú Móvil
            const mobileMenuButton = document.getElementById('mobile-menu-button');
            const sidebar = document.getElementById('sidebar');
            const sidebarOverlay = document.getElementById('sidebar-overlay');
            if (mobileMenuButton && sidebar && sidebarOverlay) { 
                mobileMenuButton.addEventListener('click', () => { 
                    sidebar.classList.toggle('-translate-x-full'); 
                    sidebarOverlay.classList.toggle('hidden'); 
                }); 
                sidebarOverlay.addEventListener('click', () => { 
                    sidebar.classList.add('-translate-x-full'); 
                    sidebarOverlay.classList.add('hidden'); 
                }); 
            }

            // Botones Ocultar/Mostrar para el widget de este documento
            document.querySelector('.hide-widget-btn[data-widget-id="awareness-video-widget"]')?.addEventListener('click', () => toggleWidgetVisibility(true));
            document.querySelector('.show-widget-btn[data-widget-id="awareness-video-widget"]')?.addEventListener('click', () => toggleWidgetVisibility(false));

            // Chequeo del estado inicial
            const isHidden = localStorage.getItem(widgetKey) === 'true';
            toggleWidgetVisibility(isHidden);

            // Inicializar Iconos Lucide
            lucide.createIcons();
        });
    })();
    </script>
<script src="files/toast.js"></script>
</body>
</html>