<?php
ob_start();
header('Content-Type: application/json');
$response = ['success' => false, 'message' => 'ERROR DESCONOCIDO'];

try {
    require_once '../core/api.php';

    ini_set('display_errors', 0);
    error_reporting(E_ALL);

    $data = json_decode(file_get_contents('php://input'), true);

    if (!isset($data['id'])) {
        throw new Exception('ID ESTIMADO REQUERIDO');
    }

    $id = filter_var($data['id'], FILTER_VALIDATE_INT);
    
    if ($id === false) {
        throw new Exception('ID INVALIDO');
    }

    // --- CORRECCIÓN: Usando la tabla quotes ---
    $sql = "DELETE FROM quotes WHERE id = ?";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$id]);

    if ($stmt->rowCount() > 0) {
        $response = ['success' => true, 'message' => 'ESTIMADO ELIMINADO'];
    } else {
        $response = ['success' => false, 'message' => 'NO ENCONTRADO (Ya eliminado o ID incorrecto)'];
    }

} catch (PDOException $e) {
    error_log("Error PDO en quote-delete.php: " . $e->getMessage());
    $response = ['success' => false, 'message' => 'ERROR DE BASE DE DATOS'];
} catch (Exception $e) {
    error_log("Error general en quote-delete.php: " . $e->getMessage());
    $response = ['success' => false, 'message' => strtoupper($e->getMessage())];
}

if (ob_get_level() > 0) {
    ob_end_clean();
}
echo json_encode($response);
exit;
?>