<?php 
ob_start();
header('Content-Type: application/json');
$response = ['success' => false, 'data' => [], 'message' => 'ERROR DESCONOCIDO'];

try {
    require_once __DIR__ . '/../core/api.php';

    ini_set('display_errors', 0);
    error_reporting(E_ALL);

    $stmt = $pdo->query("SELECT id, name FROM lead_sources ORDER BY name ASC");
    $sources = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $formatted_sources = [];
    foreach ($sources as $source) {
        $formatted_sources[] = [
            'id' => (int)$source['id'],
            'name' => $source['name']
        ];
    }

    $response = ['success' => true, 'data' => $formatted_sources];

} catch (PDOException $e) {
    error_log("Error PDO en lead-sources-read: " . $e->getMessage());
    $response['message'] = 'ERROR DE BASE DE DATOS';
} catch (Exception $e) {
    $response['message'] = $e->getMessage();
}

if (ob_get_length()) ob_clean();
echo json_encode($response);
exit;
?>