<?php
ob_start();
header('Content-Type: application/json');

require_once __DIR__ . '/../core/api.php';
global $pdo;

$response = ['success' => false, 'message' => 'Error desconocido'];

try {
    $userId = 1; 
    $businessId = 1; 

    $data = [];

    $stmt = $pdo->prepare("SELECT * FROM business_info WHERE id = ? LIMIT 1");
    $stmt->execute([$businessId]);
    $data['general'] = $stmt->fetch(PDO::FETCH_ASSOC) ?: [];

    $stmt = $pdo->prepare("SELECT tracking_codes_head, tracking_codes_body FROM tracking_codes WHERE business_info_id = ? LIMIT 1");
    $stmt->execute([$businessId]);
    $data['tracking_codes'] = $stmt->fetch(PDO::FETCH_ASSOC) ?: ['tracking_codes_head' => '', 'tracking_codes_body' => ''];

    $stmt = $pdo->prepare("SELECT email, plan_version, plan_renewal_date FROM users WHERE user_id = ? LIMIT 1");
    $stmt->execute([$userId]);
    $data['membership'] = $stmt->fetch(PDO::FETCH_ASSOC) ?: [];

    $stmt = $pdo->prepare("SELECT platform_name, link_url FROM review_links WHERE business_info_id = ?");
    $stmt->execute([$businessId]);
    $data['review_links'] = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $stmt = $pdo->prepare("SELECT * FROM schedule_config WHERE user_id = ? LIMIT 1");
    $stmt->execute([$userId]);
    $sched = $stmt->fetch(PDO::FETCH_ASSOC);
    
    $data['schedule_config'] = $sched ?: [];

    $response = ['success' => true, 'data' => $data];

} catch (PDOException $e) {
    error_log("Error DB en business-info-read.php: " . $e->getMessage());
    $response = ['success' => false, 'message' => 'Error DB: ' . $e->getMessage()];
}

ob_end_clean();
echo json_encode($response);
exit;