<?php
// /api-db/ia-whatsapp-business-optimizer-update.php
ob_start();
require_once __DIR__ . '/../client-information.php'; 
ob_clean();

header('Content-Type: application/json');

if (!isset($pdo)) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Error de conexión a la base de datos.']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);

// Espera un objeto 'ai_plan_json' que contiene el plan
if (isset($data['ai_plan_json'])) {
    $business_id = 1; // Asumiendo business_info_id = 1
    // Convierte el objeto/array del plan en un string JSON para guardarlo
    $ai_plan_string = json_encode($data['ai_plan_json']);

    if (json_last_error() !== JSON_ERROR_NONE) {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'Error al codificar el plan JSON.']);
        exit;
    }
    
    try {
        // Actualizar el campo 'ai_plan_json'
        $sql = "UPDATE ia_whatsapp_business_optimizer_results SET ai_plan_json = ? WHERE business_info_id = ?";
        
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$ai_plan_string, $business_id]);
        
        if ($stmt->rowCount() > 0) {
            echo json_encode(['success' => true, 'message' => 'Plan de acción actualizado exitosamente.']);
        } else {
            // Verificar si el registro existe
            $check_sql = "SELECT id FROM ia_whatsapp_business_optimizer_results WHERE business_info_id = ?";
            $check_stmt = $pdo->prepare($check_sql);
            $check_stmt->execute([$business_id]);
            if (!$check_stmt->fetch(PDO::FETCH_ASSOC)) {
                 http_response_code(404);
                 echo json_encode(['success' => false, 'message' => 'No se encontró ningún plan para actualizar.']);
            } else {
                 echo json_encode(['success' => true, 'message' => 'Plan de acción actualizado (sin cambios detectados).']);
            }
        }
        
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(['success' => false, 'message' => 'Error de base de datos al actualizar el plan: ' . $e->getMessage()]);
    }
} else {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'No se recibió el contenido del plan (ai_plan_json).']);
}
?>