<?php
// /IAMarketing/api-db/ia-value-propositions-update.php
ob_start();
require_once __DIR__ . '/../client-information.php'; 
ob_clean();

header('Content-Type: application/json');

if (!isset($pdo)) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Database connection error.']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);

if (isset($data['value_proposition'])) {
    $business_id = 1; // Assuming business_info_id = 1
    $vp_content = $data['value_proposition'];
    
    try {
        // Update the 'value_proposition' field in the 'ia_value_propositions' table
        $sql = "UPDATE ia_value_propositions SET value_proposition = ? WHERE business_info_id = ?";
        
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$vp_content, $business_id]);
        
        if ($stmt->rowCount() > 0) {
            echo json_encode(['success' => true, 'message' => 'Propuesta de valor actualizada con éxito']);
        } else {
            echo json_encode(['success' => true, 'message' => 'Propuesta de valor actualizada con éxito']);
        }
        
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(['success' => false, 'message' => 'Database error while updating VP: ' . $e->getMessage()]);
    }
} else {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Value proposition content not received.']);
}
?>