<?php
ob_start();
require_once __DIR__ . '/../client-information.php'; 
ob_clean();

header('Content-Type: application/json');

if (!isset($pdo)) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Error de conexión a la base de datos.']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);

if (isset($data['swot_content'])) {
    $business_id = 1; // Asumiendo business_info_id = 1 (hardcoded por ahora)
    $swot_content = $data['swot_content'];

    try {
        // 1. Verificar si ya existe un registro para business_info_id = 1
        $check_sql = "SELECT id FROM ia_swot_analysis_results WHERE business_info_id = ?";
        $check_stmt = $pdo->prepare($check_sql);
        $check_stmt->execute([$business_id]);
        
        if ($check_stmt->fetch(PDO::FETCH_ASSOC)) {
            // 409 Conflict: Ya existe un registro.
            http_response_code(409); 
            echo json_encode(['success' => false, 'message' => 'Ya existe un Análisis FODA. Por favor, use la función de actualizar o eliminar.']);
            exit;
        }
        
        // 2. Insertar el nuevo registro en la tabla dedicada
        $sql = "INSERT INTO ia_swot_analysis_results (business_info_id, swot_content) VALUES (?, ?)";
        
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$business_id, $swot_content]);
        
        echo json_encode(['success' => true, 'message' => 'Análisis FODA creado exitosamente.']);
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(['success' => false, 'message' => 'Error de base de datos al crear el FODA: ' . $e->getMessage()]);
    }
} else {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Contenido del Análisis FODA no recibido.']);
}
?>