<?php
// /IAMarketing/api-db/ia-social-post-creator-fetch.php
ob_start();
require_once __DIR__ . '/../client-information.php'; 
ob_clean();

header('Content-Type: application/json');

if (!isset($pdo)) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Database connection error.']);
    exit;
}

try {
    $business_id = 1; // Assuming business_info_id = 1

    // USANDO NOMBRE DE TABLA CORRECTO: ia_social_post_creator_results
    $sql = "SELECT 
                id, 
                post_type, 
                es_copy, 
                es_hashtags, 
                en_copy, 
                en_hashtags,
                product_service_input,
                client_description_input,
                created_at
            FROM ia_social_post_creator_results 
            WHERE business_info_id = ? 
            ORDER BY created_at DESC";
    
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$business_id]);
    
    $posts = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode([
        'success' => true, 
        'posts' => $posts
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Database error while fetching social posts: ' . $e->getMessage()]);
}
?>