<?php
// /IAMarketing/api-db/ia-services-descriptions-fetch.php
ob_start();
require_once __DIR__ . '/../client-information.php'; 
ob_clean();

header('Content-Type: application/json');

if (!isset($pdo)) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Database connection error.']);
    exit;
}

$business_id = 1;

try {
    // Select all fields needed for the panel, ordered by creation date
    $sql = "SELECT id, type, purpose_description, text_es, text_en, service_name_input, features_input, created_at FROM ia_services_descriptions_results WHERE business_info_id = ? ORDER BY created_at DESC";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$business_id]);
    $descriptions_data = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode(['success' => true, 'descriptions' => $descriptions_data, 'message' => 'Descriptions fetched successfully.'], JSON_UNESCAPED_UNICODE);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Database error while fetching descriptions: ' . $e->getMessage()]);
}
?>