<?php
// /IAMarketing/api-db/ia-post-title-generator-delete.php
ob_start();
require_once __DIR__ . '/../client-information.php'; 
ob_clean();

header('Content-Type: application/json');

if (!isset($pdo)) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Database connection error.']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);

if (!isset($data['id'])) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Title ID not received.']);
    exit;
}

$title_id = $data['id'];
$business_id = 1;

try {
    // Delete the row using the title ID AND the business ID for security
    $sql = "DELETE FROM ia_post_title_generator_results WHERE id = ? AND business_info_id = ?";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$title_id, $business_id]);
    
    if ($stmt->rowCount() > 0) {
        echo json_encode(['success' => true, 'message' => 'Título individual eliminado con éxito.']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Título no encontrado o no autorizado para eliminación.']);
    }
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Database error while deleting Title Record: ' . $e->getMessage()]);
}
?>