<?php
// /IAMarketing/api-db/ia-offers-promotions-delete.php
ob_start();
require_once __DIR__ . '/../client-information.php'; 
ob_clean();

header('Content-Type: application/json');

if (!isset($pdo)) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Database connection error.']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);

if (!isset($data['id'])) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Offer ID not received.']);
    exit;
}

$offer_id = $data['id'];
$business_id = 1;

try {
    $sql = "DELETE FROM ia_offers_promotions_results WHERE id = ? AND business_info_id = ?";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$offer_id, $business_id]);
    
    if ($stmt->rowCount() > 0) {
        echo json_encode(['success' => true, 'message' => 'Oferta individual eliminada con éxito.']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Oferta no encontrada o no autorizada para eliminación.']);
    }
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Database error while deleting Offer Record: ' . $e->getMessage()]);
}
?>