<?php
// /IAMarketing/api-db/ia-marketing-goal-planner-create.php
ob_start();
require_once __DIR__ . '/../client-information.php'; 
ob_clean();

header('Content-Type: application/json');

if (!isset($pdo)) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Error de conexión a la base de datos.']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);
$business_id = 1; // Asumiendo business_info_id = 1

// Validar que todos los campos necesarios de la IA están presentes
$required_keys = ['analisis_objetivos', 'analisis_viabilidad', 'plan_de_accion', 'metricas_clave', 'recomendaciones_optimizacion'];
foreach ($required_keys as $key) {
    if (!isset($data[$key])) {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => "Faltan datos del plan (clave: $key)."]);
        exit;
    }
}

try {
    // 1. Verificar si ya existe un registro (Lógica 1-a-1)
    $check_sql = "SELECT id FROM ia_marketing_goal_planner_results WHERE business_info_id = ?";
    $check_stmt = $pdo->prepare($check_sql);
    $check_stmt->execute([$business_id]);
    
    if ($check_stmt->fetch(PDO::FETCH_ASSOC)) {
        http_response_code(409); // Conflict
        echo json_encode(['success' => false, 'message' => 'Ya existe un Plan de Marketing. Use la función de actualizar.']);
        exit;
    }
    
    // 2. Insertar el nuevo registro
    $sql = "INSERT INTO ia_marketing_goal_planner_results 
                (business_info_id, analisis_objetivos, analisis_viabilidad, plan_de_accion, metricas_clave, recomendaciones_optimizacion) 
            VALUES (?, ?, ?, ?, ?, ?)";
    
    $stmt = $pdo->prepare($sql);
    
    // Codificar el objeto del plan de acción a JSON
    $plan_json = json_encode($data['plan_de_accion']);
    
    $stmt->execute([
        $business_id,
        $data['analisis_objetivos'],
        $data['analisis_viabilidad'],
        $plan_json,
        $data['metricas_clave'],
        $data['recomendaciones_optimizacion']
    ]);
    
    echo json_encode(['success' => true, 'message' => 'Plan de Marketing creado exitosamente.']);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Error de base de datos al crear el Plan: ' . $e->getMessage()]);
}
?>