<?php
// /IAMarketing/api-db/ia-ideal-client-generator-delete.php
ob_start();
require_once __DIR__ . '/../client-information.php'; 
ob_clean();

header('Content-Type: application/json');

if (!isset($pdo)) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Error de conexión a la base de datos.']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);
$business_id = 1; // Asumiendo business_info_id = 1

// Requerimos el ID del perfil a eliminar
if (!isset($data['id']) || !is_numeric($data['id'])) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'No se proporcionó un ID de perfil válido.']);
    exit;
}

try {
    $profile_id = $data['id'];
    
    $sql = "DELETE FROM ia_ideal_client_generator_results WHERE id = ? AND business_info_id = ?";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$profile_id, $business_id]);
    
    if ($stmt->rowCount() > 0) {
        echo json_encode(['success' => true, 'message' => 'Perfil de Cliente eliminado exitosamente.']);
    } else {
        echo json_encode(['success' => false, 'message' => 'No se encontró el perfil o no pertenece a este negocio.']);
    }
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Error de base de datos al eliminar el Perfil: ' . $e->getMessage()]);
}
?>