<?php
// /IAMarketing/api-db/ia-first-contact-message-delete.php
ob_start();
require_once __DIR__ . '/../client-information.php'; 
ob_clean();

header('Content-Type: application/json');

if (!isset($pdo)) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Database connection error.']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);

if (isset($data['id'])) {
    $message_id = $data['id'];
    $business_id = 1; // Assuming business_info_id = 1

    try {
        // Delete the row based on ID and ensure it belongs to the current business
        $sql = "DELETE FROM ia_first_contact_message_results WHERE id = ? AND business_info_id = ?";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$message_id, $business_id]);
        
        if ($stmt->rowCount() > 0) {
            echo json_encode(['success' => true, 'message' => 'Mensaje de contacto eliminado con éxito.']);
        } else {
            http_response_code(404);
            echo json_encode(['success' => false, 'message' => 'No se encontró el mensaje para eliminar.']);
        }
        
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(['success' => false, 'message' => 'Database error while deleting message: ' . $e->getMessage()]);
    }
} else {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Message ID not received for deletion.']);
}
?>