<?php
// /IAMarketing/api-db/ia-business-diagnostic-radar-delete.php
ob_start();
require_once __DIR__ . '/../client-information.php'; 
ob_clean();

header('Content-Type: application/json');

if (!isset($pdo)) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Error de conexión a la base de datos.']);
    exit;
}

// CRÍTICO: Se reemplaza el ID hardcodeado por el ID del negocio de la sesión.
$business_id = $_SESSION['business_info_id'] ?? die(json_encode(['success' => false, 'message' => 'ID de Negocio no disponible en sesión.']));

try {
    // Uso de Sentencias Preparadas (Mitigación SQLi)
    $sql = "DELETE FROM ia_business_diagnostic_radar_results WHERE business_info_id = ?";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$business_id]);
    
    if ($stmt->rowCount() > 0) {
        echo json_encode(['success' => true, 'message' => 'Radar de Diagnóstico eliminado exitosamente.']);
    } else {
        echo json_encode(['success' => true, 'message' => 'No se encontró ningún Radar para eliminar.']);
    }
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Error de base de datos al eliminar el Radar: ' . $e->getMessage()]);
}
?>