<li class="p-2 list-none">
    <div id="sidebar-banner-container">
        </div>
</li>

<script>
    (function() {
        'use strict';

        async function loadSidebarBanner() {
            const lectorUrl = 'admin/admin_banners.php';
            const bannerContainer = document.getElementById('sidebar-banner-container');

            if (!bannerContainer) {
                console.error('Error: No se encontró el contenedor del banner de la barra lateral.');
                return;
            }

            try {
                const response = await fetch(lectorUrl);
                if (!response.ok) {
                    throw new Error(`Error de red o servidor al cargar el banner: ${response.status}`);
                }
                const bannerData = await response.json();

                bannerContainer.innerHTML = '';

                if (bannerData && bannerData.image_url) {
                    const imageUrl = bannerData.image_url;
                    const linkUrl = bannerData.link_url || '#';
                    const altText = bannerData.title ? new DOMParser().parseFromString(bannerData.title, 'text/html').body.textContent : 'Anuncio';

                    const bannerHtml = `
                        <a href="${linkUrl}" class="block rounded-lg overflow-hidden" ${linkUrl !== '#' ? 'target="_blank" rel="noopener noreferrer"' : ''}>
                            <img src="${imageUrl}" alt="${altText}" class="sidebar-ad-image" loading="lazy">
                        </a>
                    `;
                    bannerContainer.innerHTML = bannerHtml;
                } else {
                    bannerContainer.innerHTML = '';
                }

            } catch (error) {
                console.error('Error al cargar el banner de la barra lateral:', error);
                bannerContainer.innerHTML = `<p class="text-sm text-red-500 text-center">Error al cargar anuncio.</p>`;
            }
        }

        document.addEventListener('DOMContentLoaded', loadSidebarBanner);

    })();
</script>