<?php
// db_connect.php - Archivo de conexión a la base de datos

// Configuración de la base de datos
// ASEGÚRATE QUE ESTOS DATOS SON EXACTOS A LOS DE TU HOSTING
define('DB_HOST', 'localhost');
define('DB_NAME', 'orozdesign_AdminLocalCRMToolKit');
define('DB_USER', 'orozdesign_ClientsCRMToolKit');
define('DB_PASS', 'a_0gHC(DXmdZTG&?W7');

error_reporting(0);
ini_set('display_errors', 0); 
ini_set('log_errors', 1); // Activar el registro de errores en el log
ini_set('error_log', __DIR__ . '/../php_errors.log'); 
// ***************************************************************


// Variable global para la conexión PDO
global $pdo;

try {
    // Intenta conectar a la base de datos
    $pdo = new PDO(
        "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4",
        DB_USER,
        DB_PASS,
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION, // Lanzar excepciones para errores
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC, // Obtener resultados como arrays asociativos
            PDO::ATTR_EMULATE_PREPARES => false // Deshabilitar la emulación (mejor seguridad y rendimiento)
        ]
    );

} catch (PDOException $e) {
    // Si la conexión falla, registra el error y redirige a la página de mantenimiento.
    error_log("Error crítico de conexión a la base de datos: " . $e->getMessage());
    header('Location: ../maintenance.php'); // Redirige a la página de mantenimiento
    exit(); // Detener la ejecución del script
} catch (Exception $e) {
    // Captura cualquier otro error inesperado y redirige.
    error_log("Error inesperado en la conexión a la base de datos: " . $e->getMessage());
    header('Location: ../maintenance.php'); // Redirige a la página de mantenimiento
    exit(); // Detener la ejecución del script
}