<?php
declare(strict_types=1);

function verifyCsrfToken(?string $submittedToken): void
{
    if (empty($_SESSION['csrf_token']) || empty($submittedToken)) {
        http_response_code(403);
        die(json_encode(['success' => false, 'message' => 'Error de Seguridad: Sesión expirada o token faltante.']));
    }

    $sessionToken = (string)$_SESSION['csrf_token'];

    if (!hash_equals($sessionToken, $submittedToken)) {
        http_response_code(403);
        die(json_encode(['success' => false, 'message' => 'Error de Seguridad: Token inválido. Recargue la página.']));
    }
}

function readJsonInput(): array
{
    $content = file_get_contents('php://input');

    if (!is_string($content) || $content === '') {
        return [];
    }

    $data = json_decode($content, true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        throw new Exception("Error de decodificación JSON: " . json_last_error_msg());
    }

    return is_array($data) ? $data : [];
}

function sanitizeData(mixed $input): mixed
{
    if (is_array($input)) {
        return array_map('sanitizeData', $input);
    }

    if (is_string($input)) {
        $string = trim($input);
        $string = strip_tags($string);
        
        $sanitized = filter_var($string, FILTER_SANITIZE_FULL_SPECIAL_CHARS, [
            'flags' => ENT_QUOTES | ENT_HTML5,
        ]);
        
        return trim($sanitized);
    }

    return $input;
}
?>