<?php
// modules.php
// LÓGICA DE VISIBILIDAD DE MÓDULOS

$active_modules_list = null; 

if (isset($pdo)) {
    try {
        // Consultamos solo la columna de configuración de módulos
        $stmtModules = $pdo->prepare("SELECT active_modules FROM business_info LIMIT 1");
        $stmtModules->execute();
        $row = $stmtModules->fetch(PDO::FETCH_ASSOC);

        if ($row && !empty($row['active_modules'])) {
            // Decodificamos el JSON guardado (ej: ["dashboard", "clients"])
            $decoded = json_decode($row['active_modules'], true);
            if (is_array($decoded)) {
                $active_modules_list = $decoded;
            }
        }
    } catch (Exception $e) {
        // Si falla la BD, no ocultamos nada por seguridad
        error_log("Error cargando módulos activos: " . $e->getMessage());
    }
}

// --- FUNCIÓN GLOBAL PARA USAR EN EL MENÚ ---
if (!function_exists('is_module_active')) {
    function is_module_active($module_key) {
        global $active_modules_list;

        // 1. Módulos "Core" (Nunca se pueden apagar porque el sistema muere)
        $core_modules = ['dashboard', 'business_config', 'account', 'profile'];
        if (in_array($module_key, $core_modules)) {
            return true;
        }

        // 2. Si la lista es NULL, el dueño no ha configurado nada -> MOSTRAR TODO
        if ($active_modules_list === null) {
            return true;
        }

        // 3. Verificar si el módulo está en la lista de activos
        return in_array($module_key, $active_modules_list);
    }
}
?>